package net.wicp.tams.common.kubernetes.beans;

import java.util.Map;

import lombok.Data;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

/***
 * 要通过DuckulaInstall来安装软件需要提供的信息
 * 
 * @author Administrator
 *
 */
@Data
public class DucklaHelmInfo {

	private ICheck checker;

	private boolean needInitK8s;

	private String helmInstanceName;// helm安装实例名，为了避免冲突，需要加些前缀或后缀之类

	private String helmValueTempPath;// helmvalue文件的最终模板的路径（classz所在jar包的路径）

	private Class<?> helmClassz;// 为了找到模板和charts包，需要此类来配置定位，模板和此类在相同的jar包（所在的任意一个类).

	private String helmChartPath;// helmChart包的包名，如：/charts/dolphinscheduler-2.0.3.tgz

	public String getHelmChartFileName() {
		Result checkRs = checker.checkHelmChartPath(this);
		if (!checkRs.isSuc()) {
			throw new ProjectExceptionRuntime(ExceptAll.Project_default, checkRs.getMessage());
		}
		int lastIndexOf = this.helmChartPath.lastIndexOf("/");
		return lastIndexOf > 0 ? this.helmChartPath.substring(lastIndexOf + 1) : this.helmChartPath;
	}

	public static interface ICheck {
		public String[] checkParams(Map<String, String> params);

		public default Result checkHelmChartPath(DucklaHelmInfo ducklaHelmInfo) {
			if (StringUtil.isNull(ducklaHelmInfo.getHelmChartPath())) {
				return Result.getError("helmChartPath不能为空");
			}
			if (!ducklaHelmInfo.getHelmChartPath().endsWith(".tgz")) {
				return Result.getError("helmChartPath必须是tgz包");
			}
			return Result.getSuc();
		}
	}
}
