CREATE TABLE IF NOT EXISTS `common_deploy`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(60),
  `deploy` varchar(255)  COMMENT '部署类型:  k8s/docker/host',
  `env` varchar(10)  COMMENT '环境：开发/测试/预发/演示/生产',
  `namespaces` varchar(1000)  COMMENT '名称空间,逗号隔开',
  `url` varchar(255) ,
  `token` varchar(2000) ,
  `secret_dockerconfigjson` varchar(2000)  COMMENT 'k8s拉取image的secret，dockerconfigjson',
  `repository` varchar(255)  COMMENT '镜像的组，与dockerconfigjson搭配使用',
  `secret_ssl_key` varchar(3000)  COMMENT '支持https的secret',
  `secret_ssl_crt` varchar(5000)  COMMENT 'storegeclass',
  `ingress_suffix` varchar(100)  COMMENT 'ingress的域名后缀',
  `ingress_flink_subdomain` varchar(50) NULL COMMENT 'flink域名的分域名',
  `config` text  COMMENT 'config配置文件',
  `config_path` varchar(255)  COMMENT 'config文件存储路径',
  `user_id` bigint(20)  COMMENT 'user表用户id',
  `host` varchar(255)  COMMENT '用户名，deploy为host才启作用',
  `port` int(11) NULL DEFAULT 22 COMMENT 'SSH端口',
  `pwd_duckula` varchar(255)  COMMENT 'duckula启动程序用密码，不保留root密码',
  `hostsconfig` varchar(20)  COMMENT '需要配置的config,对于\"host\"类型启作用',
  `storage_class` varchar(255)  COMMENT 'k8s磁盘创建class',
  `is_init` varchar(255)  COMMENT '是否初始化，yes:已初始化  no:未初始化 创建duckula用户，创建环境变量创建目录',
  `node_size` int(11) NULL DEFAULT NULL COMMENT '单node的最大内存，单位（G）',
  `docker_login` varchar(10)  COMMENT 'docker类型需要的登陆脚本',
  `is_default` varchar(10)  COMMENT '是否默认值，yes：是默认某个用户环境的部署机器  no：不是',
  `version_id` bigint(20)  COMMENT '当前的版本,host和docker模式需要升级',
  `remark` varchar(255)  COMMENT '备注',
  `create_time` datetime(0)  COMMENT '创建时间',
  `update_time` datetime(0)  ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  `create_by` bigint(20)  COMMENT '创建人id',
  `update_by` bigint(20)  COMMENT '修改人id',
  PRIMARY KEY (`id`) USING BTREE
)ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '部署相关配置，默认为：k8s环境配置';

CREATE TABLE IF NOT EXISTS `sys_tenant`  (
  `id` bigint(20) NOT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '租户编码',
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '租户名',
  `create_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '创建时间',
  `status` varchar(10) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '租户状态',
  `status_time` datetime(0) NULL DEFAULT NULL COMMENT '状态改变时间',
  `operate_reason` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '操作原因',
  `deploy_id` bigint(20) NULL DEFAULT NULL COMMENT '部署ID配置',
  `namespace` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT '名称空间',
  `middleware_id` bigint(20) NULL DEFAULT NULL COMMENT '使用的数据库配置',
  `agent_host` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '代理agent域名，它会保存文件和调试环境',
  `debug_host` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT '调试用的域名，用它启用调试功能',
  `value_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT '配置文件路径',
  `claim_pvc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL DEFAULT NULL COMMENT 'PVCID（适用于旧的项目承接）',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `deployid_namespace`(`deploy_id`, `namespace`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_bin COMMENT = '租户相关';

CREATE TABLE IF NOT EXISTS `common_version`  (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(63) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '镜像名称',
  `image_rep` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'image仓库，如果没有就用deploy配置的仓库',
  `image_group` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '开源的镜像组名',
  `image_group_user` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '自定义的镜像组名',
  `image_run_tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主程序镜像版本标签',
  `image_data_tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '数据镜像版本标签',
  `image_classify` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '镜像的分类，如：flink/duckula 等',
  `image_classify_sub` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '子分类，如：flinksql等。 是flinksql指定用镜像',
  `is_default` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '是否默认的子分类,yes',
  `deploy_date` datetime(0) NOT NULL COMMENT '发布日期',
  `user_defined` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '是否用户自定义的版本，yes:自定义， no:开源',
  `main_version` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '镜像运行程序版本',
  `scala_version` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT 'scala版本',
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '是否默认yes or no',
  `remark` varchar(2000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `name_tenantId`(`name`) USING BTREE COMMENT '惟一索引'
) ENGINE = InnoDB AUTO_INCREMENT = 14 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = 'flink基础镜像版本';
