package common.kubernetes.beans;

import java.io.File;

import com.alibaba.fastjson.JSONObject;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.TarUtil;
import net.wicp.tams.common.apiext.yaml.YamlAssist;
import net.wicp.tams.common.constant.PathType;

@Data
@Builder
public class HelmChartInfo {
	private String name;// chart名
	private Integer apiVersion;// Api版本
	private String appVersion;// app版本
	private String chartVersion;// chart版本
	private String description;// chart描述
	private String repoName;// chart仓库名
	private String uploadFilePath;// 本地chart文件路径，它与repoName只要一个就可以了
	private String valueDefault;// 默认的value内容

	/***
	 * 解析chart包
	 * 
	 * @param pathTypePath
	 * @return
	 */
	public static HelmChartInfo parseChartTgz(String pathTypePath) {
		String osPath = PathType.getPath(pathTypePath);
		File chartFile = new File(osPath);
		if (!chartFile.exists()) {
			return null;
		}
		String dir = TarUtil.deCompressTGZFile(osPath);
		JSONObject readYaml = YamlAssist.readYaml(IOUtil.mergeFolderAndFilePath(dir, "/Chart.yaml"));

		String valuePath = IOUtil.mergeFolderAndFilePath(dir, "/values.yaml");// value地址
		String slurpContext = IOUtil.slurp(valuePath);

		String apiVersionStr = readYaml.getString("apiVersion");
		HelmChartInfo chartInfo = HelmChartInfo.builder().uploadFilePath(osPath)
				.apiVersion(new Integer(apiVersionStr.replace("v", "")))
				.name(StringUtil.trimSpace(readYaml.getString("name")))
				.description(StringUtil.trimSpace(readYaml.getString("description")))
				.chartVersion(StringUtil.trimSpace(readYaml.getString("version")))
				.appVersion(StringUtil.trimSpace(readYaml.getString("appVersion"))).valueDefault(slurpContext).build();
		return chartInfo;
	}
}
