package common.kubernetes.apiserver;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;



public enum K8sKind implements IEnumCombobox {
	ReplicationController("RC"),

	ServiceAccount("帐号SA"),
	
	ClusterRole("角色");

	private final String desc;

	private K8sKind(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static YesOrNo find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (YesOrNo ele : YesOrNo.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
