package common.kubernetes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.ContentType;
import net.wicp.tams.common.http.HttpClient;
import net.wicp.tams.common.http.HttpResult;
import net.wicp.tams.common.http.HttpThread;

public abstract class K8sAssit {
	public static String getInnerUrl(Integer port, String namespace, String serviceName, String relaUrl,
			String... params) {
		String httpurl = String.format("http://%s.%s:%s", serviceName, namespace, port == null ? 80 : port);
		httpurl = IOUtil.mergeFolderAndFilePath(httpurl, relaUrl);		
		return StringUtil.packageUrlParams(httpurl, params);
	}

	public static String getInnerUrl(String namespace, String serviceName, String relaUrl, String... params) {
		return getInnerUrl(null,namespace, serviceName, relaUrl, params);
	}

	public static HttpResult uploadFile(String namespace, String serviceName, String relaUrl, ContentType contentType,
			String fileName, InputStream in) {
		String innerUrl = getInnerUrl(namespace, serviceName, relaUrl);
		HttpThread doPostJar = HttpClient.doPostFile(innerUrl, fileName, in, contentType);
		HttpResult httpResult = doPostJar.call();
		return httpResult;
	}

	public static HttpResult uploadFile(String namespace, String serviceName, String relaUrl, String fileName,
			InputStream in) {
		ContentType contentType = ContentType.findByFileName(fileName);
		return uploadFile(namespace, serviceName, relaUrl, contentType, fileName, in);
	}

	public static HttpResult uploadFile(String namespace, String serviceName, String relaUrl, File file) {
		if (!file.exists()) {
			return null;
		}
		FileInputStream in = null;
		try {
			in = new FileInputStream(file);
		} catch (FileNotFoundException e) {
		}
		return uploadFile(namespace, serviceName, relaUrl, file.getName(), in);
	}
}
