package common.kubernetes.convertvalue;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;

import common.kubernetes.beans.PodPhase;
import net.wicp.tams.common.callback.IConvertValue;

/***
 * 转换pod的状态
 * @author Andy
 *
 */
public class ConvertValuePod implements IConvertValue<String> {

	private final List<Pair<String, PodPhase>> podStatusList;

	public  ConvertValuePod(List<Pair<String, PodPhase>> podStatusList) {
		this.podStatusList = podStatusList;
	}

	@Override
	public String getStr(String keyObj) {
		for (Pair<String, PodPhase> podStatus : podStatusList) {
			if(keyObj.equals(podStatus.getLeft())) {
				return podStatus.getRight().retStatusMessage();
			}
		}
		return PodPhase.noExit.retStatusMessage();
	}

}
