package common.kubernetes.beans;

import org.apache.commons.lang3.StringUtils;

import io.kubernetes.client.openapi.models.V1PodStatus.PhaseEnum;

/**
 * 请查看 io.kubernetes.client.openapi.models.V1PodStatus.PhaseEnum
 * 
 * @author Andy
 *
 */
public enum PodPhase {
	Running("运行中"),

	Pending("正在启动"),

	Succeeded("执行完成"),

	Failed("运行失败"),

	Unknown("未知状态"),

	// 下面没有出现在：https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#pod-phase
	noExit("未布署");

	public final String desc;

	private PodPhase(String desc) {
		this.desc = desc;
	}

	public static PodPhase find(String name) {
		if (StringUtils.isEmpty(name)) {
			return noExit;
		}
		for (PodPhase ele : PodPhase.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return noExit;
	}

	public static PodPhase find(PhaseEnum name) {
		if (name == null) {
			return noExit;
		}
		for (PodPhase ele : PodPhase.values()) {
			if (name.name().equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return noExit;
	}

	public String retStatusMessage() {
		return this == PodPhase.noExit ? this.desc : String.format("%s【%s】", this.desc, this.name());
	}

}
