/*
 * Decompiled with CFR 0.152.
 */
package common.kubernetes.helm;

import common.kubernetes.helm.HelmCmd;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

public enum HelmFlags implements IEnumCombobox
{
    name("\u540d\u79f0", "name", "name", true, new IConvertValue<String>(){

        public String getStr(String keyObj) {
            return StringUtil.formatRfc1123((String)keyObj);
        }
    }, new HelmCmd[]{HelmCmd.install, HelmCmd.delete, HelmCmd.reposearch, HelmCmd.repoadd}, 0),
    namespace("\u540d\u79f0\u7a7a\u95f4", "namespace", "n", false, null, new HelmCmd[]{HelmCmd.install, HelmCmd.list, HelmCmd.delete}, Integer.MAX_VALUE),
    namespace_all("\u6240\u6709\u540d\u79f0\u7a7a\u95f4", "all-namespaces", "A", false, null, new HelmCmd[]{HelmCmd.install, HelmCmd.list, HelmCmd.delete}, Integer.MAX_VALUE, true),
    kubeconfig("k8s\u914d\u7f6e\u6587\u4ef6", "kubeconfig", null, true, new IConvertValue<String>(){

        public String getStr(String keyObj) {
            return PathType.getPath((String)keyObj);
        }
    }, new HelmCmd[]{HelmCmd.install, HelmCmd.list, HelmCmd.delete}, 0),
    kubecontext("k8s context", "kube-context", false, new HelmCmd[]{HelmCmd.install, HelmCmd.list, HelmCmd.delete}),
    url("chartrepo\u5730\u5740", null, null, true, null, new HelmCmd[]{HelmCmd.repoadd}, 1),
    filter("\u8fc7\u6ee4", "filter", "f", false, null, new HelmCmd[]{HelmCmd.list}, 0),
    reponame("\u672c\u5730\u4ed3\u5e93\u540d", null, null, true, null, new HelmCmd[]{HelmCmd.chartpush}, 0x7FFFFFFE),
    chartLocalpath("chart\u5305\u8def\u5f84", null, null, false, new IConvertValue<String>(){

        public String getStr(String keyObj) {
            return PathType.getPath((String)keyObj);
        }
    }, new HelmCmd[]{HelmCmd.install}, 0x7FFFFFFD),
    version("chart\u7248\u672c", "version", null, false, null, new HelmCmd[]{HelmCmd.install, HelmCmd.chartfetch}, 0x7FFFFFFE),
    chartFilePath("\u672c\u5730\u6587\u4ef6\u540d\u6216\u76ee\u5f55\u540d", null, null, false, null, new HelmCmd[]{HelmCmd.chartpush, HelmCmd.install, HelmCmd.chartfetch}, 0x7FFFFFFD),
    set("\u8986\u76d6\u53c2\u6570\uff08\u5c11\u91cf\uff09", "set", null, false, null, new HelmCmd[]{HelmCmd.install}, 0x7FFFFFFC),
    values("\u7528\u6237\u81ea\u5b9a\u4e49\u7684\u53c2\u6570\uff08\u5927\u91cf\uff09", "values", "f", false, new IConvertValue<String>(){

        public String getStr(String keyObj) {
            return PathType.getPath((String)keyObj);
        }
    }, new HelmCmd[]{HelmCmd.install}, 0x7FFFFFFB),
    destination("package\u6253\u5305\u7684\u76ee\u7684\u76ee\u5f55\uff0c\u4e0d\u9700\u8981k8s\u914d\u7f6e", "destination", "d", false, null, new HelmCmd[]{HelmCmd.chartPackage}, 2),
    dependency_update("package\u6253\u5305\u524d\u66f4\u65b0\u4f9d\u8d56\u5230charts/\u76ee\u5f55", "dependency-update", "u", false, null, new HelmCmd[]{HelmCmd.chartPackage}, 0x7FFFFFFD, true);

    private final String desc;
    private final String paramName;
    private final String paramShortName;
    private final boolean notnull;
    private final boolean notvalue;
    private final IConvertValue<String> formart;
    private final HelmCmd[] cmds;
    private final int orderby;

    public static String proCommonParmStr(HelmCmd cmd, Map<HelmFlags, String> values) {
        HelmFlags[] flags;
        if (MapUtils.isEmpty(values)) {
            return cmd.getCmd();
        }
        for (HelmFlags helmFlags : flags = HelmFlags.values()) {
            if (helmFlags.notvalue || !ArrayUtils.contains((Object[])helmFlags.getCmds(), (Object)((Object)cmd)) || !helmFlags.isNotnull() || values == null || !StringUtil.isNull((Object)values.get((Object)helmFlags))) continue;
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, helmFlags.getDesc() + "\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        switch (cmd) {
            case install: {
                String chartLocalpath = values.get((Object)HelmFlags.chartLocalpath);
                String chartFilePath = values.get((Object)HelmFlags.chartFilePath);
                String version = values.get((Object)HelmFlags.version);
                if (!StringUtil.isNull((Object)chartLocalpath) || !StringUtil.isNull((Object)chartFilePath) && !StringUtil.isNull((Object)version)) break;
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "\u5b89\u88c5chart\u9700\u8981\u4f20\u5165chartLocalpath\u6216 chartFilePath\u548cversion\u7684\u7ec4\u5408");
            }
            case chartfetch: {
                if (!StringUtil.isNull((Object)values.get((Object)chartFilePath)) && !StringUtil.isNull((Object)values.get((Object)version))) break;
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "chartfetch\u9700\u8981chartFilePath\u548cversion\u7684\u7ec4\u5408");
            }
        }
        if (StringUtil.isNotNull((Object)values.get((Object)namespace)) && values.containsKey((Object)namespace_all)) {
            values.remove((Object)namespace_all);
        }
        Arrays.parallelSort(flags, new Comparator<HelmFlags>(){

            @Override
            public int compare(HelmFlags o1, HelmFlags o2) {
                return o1.getOrderby() - o2.getOrderby();
            }
        });
        StringBuffer buff = new StringBuffer(cmd.getCmd());
        if (MapUtils.isNotEmpty(values)) {
            for (int i = 0; i < flags.length; ++i) {
                String[] valueAry;
                String[] stringArray;
                String value;
                if (!ArrayUtils.contains((Object[])flags[i].getCmds(), (Object)((Object)cmd)) || !values.containsKey((Object)flags[i])) continue;
                if (flags[i].isNotvalue()) {
                    if (flags[i].getParamShortName() != null) {
                        buff.append(String.format(" -%s", flags[i].getParamShortName()));
                        continue;
                    }
                    buff.append(String.format(" --%s", flags[i].getParamName()));
                    continue;
                }
                if (!StringUtil.isNotNull((Object)values.get((Object)flags[i]))) continue;
                String string = value = flags[i].getFormart() == null ? values.get((Object)flags[i]) : flags[i].getFormart().getStr((Object)values.get((Object)flags[i]));
                if (StringUtil.isNull((Object)flags[i].getParamName()) && StringUtil.isNull((Object)flags[i].paramShortName)) {
                    buff.append(" " + value);
                    continue;
                }
                if (flags[i] == set) {
                    stringArray = value.split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = value;
                }
                for (String valueEle : valueAry = stringArray) {
                    if (flags[i].getParamShortName() != null) {
                        buff.append(String.format(" -%s %s", flags[i].getParamShortName(), valueEle));
                        continue;
                    }
                    buff.append(String.format(" --%s %s", flags[i].getParamName(), valueEle));
                }
            }
        }
        return buff.toString();
    }

    private HelmFlags(String desc, String paramName, String paramShortName, boolean notnull, IConvertValue<String> formart, HelmCmd[] cmds, int orderby, boolean notvalue) {
        this.desc = desc;
        this.paramName = paramName;
        this.paramShortName = paramShortName;
        this.notnull = notnull;
        this.formart = formart;
        this.cmds = cmds;
        this.orderby = orderby;
        this.notvalue = notvalue;
    }

    private HelmFlags(String desc, String paramName, String paramShortName, boolean notnull, IConvertValue<String> formart, HelmCmd[] cmds, int orderby) {
        this(desc, paramName, paramShortName, notnull, formart, cmds, orderby, false);
    }

    private HelmFlags(String desc, String paramName, boolean notnull, HelmCmd[] cmds) {
        this(desc, paramName, null, notnull, null, cmds, 0);
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.name();
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getParamShortName() {
        return this.paramShortName;
    }

    public boolean isNotnull() {
        return this.notnull;
    }

    public IConvertValue<String> getFormart() {
        return this.formart;
    }

    public HelmCmd[] getCmds() {
        return this.cmds;
    }

    public int getOrderby() {
        return this.orderby;
    }

    public boolean isNotvalue() {
        return this.notvalue;
    }
}

