/*
 * Decompiled with CFR 0.152.
 */
package common.kubernetes.helm;

import common.kubernetes.helm.HelmCmd;
import common.kubernetes.helm.HelmFlags;
import common.kubernetes.helm.po.HelmInst;
import common.kubernetes.helm.po.RepoInst;
import io.fabric8.kubernetes.client.Config;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.OSinfo;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelmClient {
    private static final Logger log;
    private final String configPath;
    private final String namespaceDefault;
    private final String context;
    private static final Map<String, RepoInst> repomap;

    public HelmClient(String pathTypePath, String context, String namespace) {
        this.configPath = PathType.getPath((String)pathTypePath);
        String kubeconfigstr = IOUtil.slurp((String)this.configPath);
        Config config = StringUtil.isNull((Object)context) ? Config.fromKubeconfig((String)kubeconfigstr) : Config.fromKubeconfig((String)context, (String)kubeconfigstr, null);
        this.context = config.getCurrentContext().getName();
        this.namespaceDefault = StringUtil.hasNull((String[])new String[]{namespace, config.getCurrentContext().getContext().getNamespace()});
    }

    public HelmClient(String pathTypePath, String namespace) {
        this(pathTypePath, null, namespace);
    }

    public HelmClient(String pathTypePath) {
        this(pathTypePath, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final RepoInst getRepo(String name) {
        if (StringUtil.isNull((Object)name)) {
            return null;
        }
        if (repomap.get(name) != null) return repomap.get(name);
        Class<HelmClient> clazz = HelmClient.class;
        synchronized (HelmClient.class) {
            RepoInst temp;
            Result addRepo;
            if (repomap.get(name) != null) return repomap.get(name);
            Map map = Conf.getPre((String)String.format("common.helm.repo.%s", name), (boolean)true);
            log.info("\u5b89\u88c5repo{},\u627e\u5230\u914d\u7f6e\u9879\uff1a{}", (Object)name, (Object)map.size());
            RepoInst.RepoInstBuilder builder = RepoInst.builder().name(name);
            builder.url((String)map.get("url"));
            if (map.containsKey("username")) {
                builder.username(StringUtil.hasNull((String[])new String[]{(String)map.get("username"), ""}));
            }
            if (map.containsKey("password")) {
                builder.password(StringUtil.hasNull((String[])new String[]{(String)map.get("password"), ""}));
            }
            if ((addRepo = HelmClient.addRepo(temp = builder.build())).isSuc()) {
                repomap.put(name, temp);
                log.info("\u5b89\u88c5repo:{}\u6210\u529f", (Object)name);
            } else {
                log.error("\u5b89\u88c5repo\u5931\u8d25,\u539f\u56e0\uff1a{}", (Object)addRepo.getMessage());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return repomap.get(name);
        }
    }

    public static RepoInst getRepoNoConf(String name, Properties props) {
        if (repomap.containsKey(name) && repomap.get(name) != null) {
            log.warn("\u5df2\u5b58\u5728\u6b64\u914d\u7f6e,\u53ef\u4ee5\u8c03\u7528getDataSource\u62ff\u5230\u6570\u636e\u6e90");
            return repomap.get(name);
        }
        Properties propsDefault = Conf.getPreToProp((String)"common.helm.repo.default", (boolean)true);
        for (Object key : props.keySet()) {
            propsDefault.put(String.valueOf(key), props.get(key));
        }
        Properties overprops = new Properties();
        for (Object keyobj : propsDefault.keySet()) {
            overprops.put(String.format("common.helm.repo.%s.%s", name, keyobj), propsDefault.get(keyobj));
        }
        Conf.overProp((Properties)overprops);
        return HelmClient.getRepo(name);
    }

    public static Result addRepo(RepoInst repoInst) {
        if (OSinfo.isWindows()) {
            HashMap<HelmFlags, String> values = new HashMap<HelmFlags, String>();
            values.put(HelmFlags.name, repoInst.getName());
            values.put(HelmFlags.url, repoInst.getUrl());
            Result call = HelmClient.call(HelmCmd.repoadd, values);
            return call;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("export HELM_REPO_USERNAME='" + repoInst.getUsername() + "';\n");
        buff.append("export HELM_REPO_PASSWORD='" + repoInst.getPassword() + "';\n");
        buff.append(String.format("helm repo add %s %s --username ${HELM_REPO_USERNAME} --password ${HELM_REPO_PASSWORD}", repoInst.getName(), repoInst.getUrl()));
        try {
            String shellPath = IOUtil.mergeFolderAndFilePath((String)System.getProperty("user.home"), (String[])new String[]{"helmchart.sh"});
            FileUtils.writeStringToFile((File)new File(shellPath), (String)buff.toString());
            Result startCmd = OSinfo.startCmd((String)("/bin/sh " + shellPath), HelmCmd.install.getConvertResult());
            return startCmd;
        }
        catch (IOException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_datenofitformate, "\u6dfb\u52a0repo\u5931\u8d25", (Throwable)e);
        }
    }

    public static Result call(HelmCmd helmCmd, Map<HelmFlags, String> values) {
        try {
            String cmd = HelmFlags.proCommonParmStr(helmCmd, values);
            log.info("the command:{}", (Object)cmd);
            Result startCmd = OSinfo.startCmd((String)cmd, helmCmd.getConvertResult());
            if (!startCmd.isSuc()) {
                log.error("helm call\u5931\u8d25,\u539f\u56e0\uff1a{}", (Object)startCmd.getMessage());
                return Result.getError((String)startCmd.getMessage());
            }
            return startCmd;
        }
        catch (Throwable e) {
            log.error("helm call\u5931\u8d25", e);
            return Result.getError((String)e.getMessage());
        }
    }

    public static Result install(Map<HelmFlags, String> values, boolean updateRepo) {
        Result updateRs = Result.getSuc();
        if (updateRepo && !(updateRs = HelmClient.updateRepo()).isSuc()) {
            return updateRs;
        }
        Result result = HelmClient.call(HelmCmd.chartfetch, values);
        if (result.isSuc()) {
            Result rs = HelmClient.call(HelmCmd.install, values);
            return rs;
        }
        return result;
    }

    public Result installLocalFile(String name, String chartPath, String namespace, String valueFilePath, Map<String, String> setParams) {
        Map<HelmFlags, String> values = this.configKubeCommon(namespace);
        values.put(HelmFlags.name, name);
        values.put(HelmFlags.chartLocalpath, chartPath);
        if (StringUtil.isNotNull((Object)valueFilePath)) {
            values.put(HelmFlags.values, valueFilePath);
        }
        String mapstrs = CollectionUtil.toPropString(setParams, (String)",");
        values.put(HelmFlags.set, mapstrs);
        Result rs = HelmClient.call(HelmCmd.install, values);
        return rs;
    }

    public Result installLocalFile(String name, String chartPath, String namespace, String valueFilePath, String[] setParams) {
        Map parms = CollectionUtil.newMapStr((String[])setParams);
        return this.installLocalFile(name, chartPath, namespace, valueFilePath, parms);
    }

    public Result installLocalFile(String name, File chartFile, String namespace, File valueFile, String ... setParams) {
        return this.installLocalFile(name, chartFile.getPath(), namespace, valueFile.getPath(), setParams);
    }

    public Result installLocalFileDefaultNs(String name, String pathTypeChartFilePath, String pathTypeValueFilePath, String ... setParams) {
        return this.installLocalFile(name, PathType.getPath((String)pathTypeChartFilePath), null, PathType.getPath((String)pathTypeValueFilePath), setParams);
    }

    public List<HelmInst> listInstance(String filtername, String namespace) {
        Map<HelmFlags, String> values = this.configKubeCommon(namespace);
        values.put(HelmFlags.filter, filtername);
        Result rs = HelmClient.call(HelmCmd.list, values);
        HelmInst[] retObjs = (HelmInst[])rs.retObjs();
        return Arrays.asList(retObjs);
    }

    public List<HelmInst> listInstanceGloble(String filtername) {
        Map<HelmFlags, String> values = this.configKubeCommon(null);
        values.remove((Object)HelmFlags.namespace);
        values.put(HelmFlags.namespace_all, null);
        values.put(HelmFlags.filter, filtername);
        Result rs = HelmClient.call(HelmCmd.list, values);
        HelmInst[] retObjs = (HelmInst[])rs.retObjs();
        return Arrays.asList(retObjs == null ? new HelmInst[]{} : retObjs);
    }

    public Result deleteInstall(String name, String namespace) {
        Map<HelmFlags, String> values = this.configKubeCommon(namespace);
        values.put(HelmFlags.name, name);
        Result rs = HelmClient.call(HelmCmd.delete, values);
        return rs;
    }

    private Map<HelmFlags, String> configKubeCommon(String namespace) {
        HashMap<HelmFlags, String> values = new HashMap<HelmFlags, String>();
        values.put(HelmFlags.kubeconfig, this.configPath);
        values.put(HelmFlags.namespace, StringUtil.hasNull((String[])new String[]{namespace, this.namespaceDefault}));
        values.put(HelmFlags.kubecontext, this.context);
        return values;
    }

    public Result deleteInstall(String name) {
        return this.deleteInstall(name, null);
    }

    public static IConvertValue<String> getConvert(Map<HelmFlags, String> values) {
        Result call = HelmClient.call(HelmCmd.list, values);
        final HelmInst[] helmInsts = (HelmInst[])call.retObjs();
        return new IConvertValue<String>(){

            public String getStr(String keyObj) {
                if (StringUtil.isNull((Object)keyObj)) {
                    return "";
                }
                String keyObjTrue = StringUtil.formatRfc1123((String)keyObj);
                for (HelmInst helmInst : helmInsts) {
                    if (!keyObjTrue.equals(helmInst.getName())) continue;
                    return helmInst.getStatus();
                }
                return "\u672a\u90e8\u7f72";
            }
        };
    }

    public static Result updateRepo() {
        Result result = HelmClient.call(HelmCmd.repoupdate, null);
        if (!result.isSuc()) {
            log.warn("\u66f4\u65b0chart\u5305\u7d22\u5f15\u5931\u8d25\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u641c\u7d22chart\u4e0d\u51c6\u786e");
            return result;
        }
        return result;
    }

    public static Result listCharts(String chartName, boolean forceupdate) {
        Result result;
        if (forceupdate && !(result = HelmClient.updateRepo()).isSuc()) {
            return result;
        }
        HashMap<HelmFlags, String> values = new HashMap<HelmFlags, String>();
        values.put(HelmFlags.name, chartName);
        Result call = HelmClient.call(HelmCmd.reposearch, values);
        return call;
    }

    public static Result pushChart(String chartFilePath, String reponame) {
        HashMap<HelmFlags, String> values = new HashMap<HelmFlags, String>();
        values.put(HelmFlags.chartFilePath, chartFilePath);
        values.put(HelmFlags.reponame, reponame);
        Result call = HelmClient.call(HelmCmd.chartpush, values);
        return call;
    }

    public static void saveK8sConfFile(String pathTrue, String context) {
        try {
            FileUtils.write((File)new File(pathTrue), (CharSequence)context);
            if (OSinfo.isLinux()) {
                OSinfo.startCmd((String)("chmod g-r,o-r " + pathTrue), null);
                log.info("\u4fee\u6539{}\u6743\u9650\u6210\u529f", (Object)pathTrue);
            } else {
                log.info("\u64cd\u4f5c\u7cfb\u7edf\u4e3a{}\uff0c\u4e0d\u9700\u8981\u4fee\u6539{}", (Object)OSinfo.getOSname(), (Object)pathTrue);
            }
        }
        catch (IOException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_other, "\u4fdd\u5b58k8s\u6587\u4ef6\u65f6\u9519\u8bef", (Throwable)e);
        }
    }

    public static void saveK8sConfFilePathType(String pathTypeStr, String context) {
        HelmClient.saveK8sConfFile(PathType.getPath((String)pathTypeStr), context);
    }

    static {
        Object[] retObjs;
        log = LoggerFactory.getLogger(HelmClient.class);
        repomap = new HashMap<String, RepoInst>();
        Map repoConfMap = Conf.getPreGroup((String)"common.helm.repo.", (String[])new String[0]);
        for (String reponame : repoConfMap.keySet()) {
            Map repoconf = (Map)repoConfMap.get(reponame);
            if (StringUtil.isNull(repoconf.get("url")) || StringUtil.isNull(repoconf.get("username")) || StringUtil.isNull(repoconf.get("password"))) {
                log.error("[%s]repo config url/username/password is not null", (Object)reponame);
                continue;
            }
            RepoInst repoInst = RepoInst.builder().name(reponame).username(StringUtil.trimSpace((String)((String)repoconf.get("username")))).password(StringUtil.trimSpace((String)((String)repoconf.get("password")))).url(StringUtil.trimSpace((String)((String)repoconf.get("url")))).build();
            Result addRepo = HelmClient.addRepo(repoInst);
            if (!addRepo.isSuc()) {
                String errormsg = "[" + reponame + "]repo regist error:" + addRepo.getMessage();
                if ("yes".equals(repoconf.get("forcecheck"))) {
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, errormsg);
                }
                log.error(errormsg);
                continue;
            }
            log.info(addRepo.getMessage());
        }
        Result call = HelmClient.call(HelmCmd.repolist, null);
        if (call.isSuc() && ArrayUtils.isNotEmpty((Object[])call.retObjs()) && ArrayUtils.isNotEmpty((Object[])(retObjs = call.retObjs()))) {
            for (Object object : retObjs) {
                RepoInst ele = (RepoInst)object;
                repomap.put(ele.getName(), ele);
            }
        }
    }
}

