/*
 * Decompiled with CFR 0.152.
 */
package common.kubernetes.convertvalue;

import common.kubernetes.helm.HelmClient;
import common.kubernetes.helm.HelmCmd;
import common.kubernetes.helm.HelmFlags;
import common.kubernetes.helm.IConvertParams;
import common.kubernetes.helm.po.HelmInst;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertValueHelmStatus<T>
implements IConvertValue<T> {
    private static final Logger log = LoggerFactory.getLogger(ConvertValueHelmStatus.class);
    private final IConvertParams<T> packer;
    private final String nameForNameCol;
    private final String[] fitHelmNames;

    public ConvertValueHelmStatus(IConvertParams<T> packer, String nameForNameCol) {
        this.packer = packer;
        this.nameForNameCol = nameForNameCol;
        this.fitHelmNames = null;
    }

    public ConvertValueHelmStatus(IConvertParams<T> packer, String[] fitHelmNames) {
        this.packer = packer;
        this.nameForNameCol = null;
        this.fitHelmNames = fitHelmNames;
    }

    public String getStr(T keyObj) {
        Map<HelmFlags, String> values = this.packer.pack(keyObj);
        Result call = HelmClient.call(HelmCmd.list, values);
        if (!call.isSuc()) {
            return "\u5f02\u5e38";
        }
        if (ArrayUtils.isEmpty((Object[])call.retObjs())) {
            return "\u672a\u90e8\u7f72";
        }
        for (Object obj : call.retObjs()) {
            HelmInst helmInst = (HelmInst)obj;
            try {
                if (ArrayUtils.isNotEmpty((Object[])this.fitHelmNames) && ArrayUtils.contains((Object[])this.fitHelmNames, (Object)helmInst.getName())) {
                    return helmInst.getStatus();
                }
                if (!StringUtil.isNotNull((Object)this.nameForNameCol) || !helmInst.getName().equals(BeanUtils.getProperty(keyObj, (String)this.nameForNameCol))) continue;
                return helmInst.getStatus();
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
        }
        return "\u672a\u90e8\u7f72";
    }
}

