/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm;

import com.github.zafarkhaja.semver.Version;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpec;
import io.fabric8.kubernetes.api.model.apps.DoneableDeployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.HttpClientAware;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.microbean.development.annotation.Experimental;
import org.microbean.helm.Tiller;
import org.microbean.helm.TillerNotAvailableException;
import org.microbean.helm.TillerPollingDeadlineExceededException;
import org.microbean.kubernetes.Pods;

@Experimental
public class TillerInstaller {
    private static final Integer ONE = 1;
    private static final ImagePullPolicy DEFAULT_IMAGE_PULL_POLICY = ImagePullPolicy.IF_NOT_PRESENT;
    private static final String DEFAULT_NAME = "tiller";
    private static final String DEFAULT_NAMESPACE = "kube-system";
    private static final String TILLER_TLS_CERTS_PATH = "/etc/certs";
    public static final String VERSION = "2.8.2";
    private static final Pattern TILLER_VERSION_PATTERN = Pattern.compile(":v(.+)$");
    private static final String DEFAULT_IMAGE_NAME = "gcr.io/kubernetes-helm/tiller:v2.8.2";
    private static final String DEFAULT_DEPLOYMENT_NAME = "tiller-deploy";
    private static final String SECRET_NAME = "tiller-secret";
    private final KubernetesClient kubernetesClient;
    private final String tillerNamespace;

    public TillerInstaller() {
        this((KubernetesClient)new DefaultKubernetesClient(), null);
    }

    public TillerInstaller(KubernetesClient kubernetesClient) {
        this(kubernetesClient, null);
    }

    public TillerInstaller(KubernetesClient kubernetesClient, String tillerNamespace) {
        Objects.requireNonNull(kubernetesClient);
        this.kubernetesClient = kubernetesClient;
        if (tillerNamespace == null || tillerNamespace.isEmpty()) {
            tillerNamespace = System.getProperty("tiller.namespace", System.getenv("TILLER_NAMESPACE"));
        }
        this.tillerNamespace = tillerNamespace == null || tillerNamespace.isEmpty() ? DEFAULT_NAMESPACE : tillerNamespace;
    }

    public void init() {
        try {
            this.init(false, null, null, null, null, null, null, null, null, 0, false, false, false, null, null, null, -1L);
        }
        catch (IOException willNotHappen) {
            throw new AssertionError((Object)willNotHappen);
        }
    }

    public void init(boolean upgrade) {
        try {
            this.init(upgrade, null, null, null, null, null, null, null, null, 0, false, false, false, null, null, null, -1L);
        }
        catch (IOException willNotHappen) {
            throw new AssertionError((Object)willNotHappen);
        }
    }

    public void init(boolean upgrade, long tillerConnectionTimeout) {
        try {
            this.init(upgrade, null, null, null, null, null, null, null, null, 0, false, false, false, null, null, null, tillerConnectionTimeout);
        }
        catch (IOException willNotHappen) {
            throw new AssertionError((Object)willNotHappen);
        }
    }

    @Deprecated
    public void init(boolean upgrade, String namespace, String deploymentName, String serviceName, Map<String, String> labels, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, boolean hostNetwork, boolean tls, boolean verifyTls, URI tlsKeyUri, URI tlsCertUri, URI tlsCaCertUri) throws IOException {
        this.init(upgrade, namespace, deploymentName, serviceName, labels, null, serviceAccountName, imageName, imagePullPolicy, 0, hostNetwork, tls, verifyTls, tlsKeyUri, tlsCertUri, tlsCaCertUri, -1L);
    }

    public void init(boolean upgrade, String namespace, String deploymentName, String serviceName, Map<String, String> labels, Map<String, String> nodeSelector, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, int maxHistory, boolean hostNetwork, boolean tls, boolean verifyTls, URI tlsKeyUri, URI tlsCertUri, URI tlsCaCertUri, long tillerConnectionTimeout) throws IOException {
        block4: {
            namespace = this.normalizeNamespace(namespace);
            deploymentName = TillerInstaller.normalizeDeploymentName(deploymentName);
            serviceName = TillerInstaller.normalizeServiceName(serviceName);
            labels = TillerInstaller.normalizeLabels(labels);
            serviceAccountName = TillerInstaller.normalizeServiceAccountName(serviceAccountName);
            imageName = TillerInstaller.normalizeImageName(imageName);
            try {
                this.install(namespace, deploymentName, serviceName, labels, nodeSelector, serviceAccountName, imageName, imagePullPolicy, maxHistory, hostNetwork, tls, verifyTls, tlsKeyUri, tlsCertUri, tlsCaCertUri);
            }
            catch (KubernetesClientException kubernetesClientException) {
                Status status = kubernetesClientException.getStatus();
                if (status == null || !"AlreadyExists".equals(status.getReason())) {
                    throw kubernetesClientException;
                }
                if (!upgrade) break block4;
                this.upgrade(namespace, deploymentName, serviceName, serviceAccountName, imageName, imagePullPolicy, labels);
            }
        }
        if (tillerConnectionTimeout >= 0L && this.kubernetesClient instanceof HttpClientAware) {
            this.ping(namespace, labels, tillerConnectionTimeout);
        }
    }

    public void install() {
        try {
            this.install(null, null, null, null, null, null, null, null, 0, false, false, false, null, null, null);
        }
        catch (IOException willNotHappen) {
            throw new AssertionError((Object)willNotHappen);
        }
    }

    public void install(String namespace, String deploymentName, String serviceName, Map<String, String> labels, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, boolean hostNetwork, boolean tls, boolean verifyTls, URI tlsKeyUri, URI tlsCertUri, URI tlsCaCertUri) throws IOException {
        this.install(namespace, deploymentName, serviceName, labels, null, serviceAccountName, imageName, imagePullPolicy, 0, hostNetwork, tls, verifyTls, tlsKeyUri, tlsCertUri, tlsCaCertUri);
    }

    public void install(String namespace, String deploymentName, String serviceName, Map<String, String> labels, Map<String, String> nodeSelector, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, int maxHistory, boolean hostNetwork, boolean tls, boolean verifyTls, URI tlsKeyUri, URI tlsCertUri, URI tlsCaCertUri) throws IOException {
        namespace = this.normalizeNamespace(namespace);
        labels = TillerInstaller.normalizeLabels(labels);
        Deployment deployment = this.createDeployment(namespace, TillerInstaller.normalizeDeploymentName(deploymentName), labels, nodeSelector, TillerInstaller.normalizeServiceAccountName(serviceAccountName), TillerInstaller.normalizeImageName(imageName), imagePullPolicy, maxHistory, hostNetwork, tls, verifyTls);
        Service service = this.createService(namespace, TillerInstaller.normalizeServiceName(serviceName), labels);
        ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).create((Object)service);
        if (tls) {
            Secret secret = this.createSecret(namespace, tlsKeyUri, tlsCertUri, tlsCaCertUri, labels);
            ((NonNamespaceOperation)this.kubernetesClient.secrets().inNamespace(namespace)).create((Object)secret);
        }
    }

    public void upgrade() {
        this.upgrade(null, null, null, null, null, null, null, false);
    }

    public void upgrade(String namespace, String deploymentName, String serviceName, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, Map<String, String> labels) {
        this.upgrade(namespace, deploymentName, serviceName, serviceAccountName, imageName, imagePullPolicy, labels, false);
    }

    public void upgrade(String namespace, String deploymentName, String serviceName, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, Map<String, String> labels, boolean force) {
        namespace = this.normalizeNamespace(namespace);
        serviceName = TillerInstaller.normalizeServiceName(serviceName);
        Resource resource = (Resource)((NonNamespaceOperation)this.kubernetesClient.extensions().deployments().inNamespace(namespace)).withName(TillerInstaller.normalizeDeploymentName(deploymentName));
        assert (resource != null);
        if (!force) {
            String serverTillerImage = ((Container)((Deployment)resource.get()).getSpec().getTemplate().getSpec().getContainers().get(0)).getImage();
            assert (serverTillerImage != null);
            if (TillerInstaller.isServerTillerVersionGreaterThanClientTillerVersion(serverTillerImage)) {
                throw new IllegalStateException(serverTillerImage + " is newer than " + VERSION + "; use force=true to force downgrade");
            }
        }
        Container container = (Container)((DoneableDeployment)resource.edit()).getSpec().getTemplate().getSpec().getContainers().get(0);
        container.setImage(TillerInstaller.normalizeImageName(imageName));
        container.setImagePullPolicy(TillerInstaller.normalizeImagePullPolicy(imagePullPolicy));
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).withName(serviceName)).get();
        if (service == null) {
            this.createService(namespace, serviceName, TillerInstaller.normalizeLabels(labels));
        }
    }

    protected Service createService(String namespace, String serviceName, Map<String, String> labels) {
        labels = TillerInstaller.normalizeLabels(labels);
        Service service = new Service();
        ObjectMeta metadata = new ObjectMeta();
        metadata.setNamespace(this.normalizeNamespace(namespace));
        metadata.setName(TillerInstaller.normalizeServiceName(serviceName));
        metadata.setLabels(labels);
        service.setMetadata(metadata);
        service.setSpec(this.createServiceSpec(labels));
        return service;
    }

    protected Deployment createDeployment(String namespace, String deploymentName, Map<String, String> labels, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, boolean hostNetwork, boolean tls, boolean verifyTls) {
        return this.createDeployment(namespace, deploymentName, labels, null, serviceAccountName, imageName, imagePullPolicy, 0, hostNetwork, tls, verifyTls);
    }

    protected Deployment createDeployment(String namespace, String deploymentName, Map<String, String> labels, Map<String, String> nodeSelector, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, int maxHistory, boolean hostNetwork, boolean tls, boolean verifyTls) {
        namespace = this.normalizeNamespace(namespace);
        labels = TillerInstaller.normalizeLabels(labels);
        Deployment deployment = new Deployment();
        ObjectMeta metadata = new ObjectMeta();
        metadata.setNamespace(namespace);
        metadata.setName(TillerInstaller.normalizeDeploymentName(deploymentName));
        metadata.setLabels(labels);
        deployment.setMetadata(metadata);
        deployment.setSpec(this.createDeploymentSpec(labels, nodeSelector, serviceAccountName, imageName, imagePullPolicy, maxHistory, namespace, hostNetwork, tls, verifyTls));
        return deployment;
    }

    protected Secret createSecret(String namespace, URI tlsKeyUri, URI tlsCertUri, URI tlsCaCertUri, Map<String, String> labels) throws IOException {
        Secret secret = new Secret();
        secret.setType("Opaque");
        HashMap<String, String> secretData = new HashMap<String, String>();
        try (InputStream tlsKeyStream = TillerInstaller.read(tlsKeyUri);){
            if (tlsKeyStream != null) {
                secretData.put("tls.key", Base64.getEncoder().encodeToString(TillerInstaller.toByteArray(tlsKeyStream)));
            }
        }
        try (InputStream tlsCertStream = TillerInstaller.read(tlsCertUri);){
            if (tlsCertStream != null) {
                secretData.put("tls.crt", Base64.getEncoder().encodeToString(TillerInstaller.toByteArray(tlsCertStream)));
            }
        }
        try (InputStream tlsCaCertStream = TillerInstaller.read(tlsCaCertUri);){
            if (tlsCaCertStream != null) {
                secretData.put("ca.crt", Base64.getEncoder().encodeToString(TillerInstaller.toByteArray(tlsCaCertStream)));
            }
        }
        secret.setData(secretData);
        ObjectMeta metadata = new ObjectMeta();
        metadata.setNamespace(this.normalizeNamespace(namespace));
        metadata.setName(SECRET_NAME);
        metadata.setLabels(TillerInstaller.normalizeLabels(labels));
        secret.setMetadata(metadata);
        return secret;
    }

    protected DeploymentSpec createDeploymentSpec(Map<String, String> labels, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, String namespace, boolean hostNetwork, boolean tls, boolean verifyTls) {
        return this.createDeploymentSpec(labels, null, serviceAccountName, imageName, imagePullPolicy, 0, namespace, hostNetwork, tls, verifyTls);
    }

    protected DeploymentSpec createDeploymentSpec(Map<String, String> labels, Map<String, String> nodeSelector, String serviceAccountName, String imageName, ImagePullPolicy imagePullPolicy, int maxHistory, String namespace, boolean hostNetwork, boolean tls, boolean verifyTls) {
        DeploymentSpec deploymentSpec = new DeploymentSpec();
        PodTemplateSpec podTemplateSpec = new PodTemplateSpec();
        ObjectMeta metadata = new ObjectMeta();
        metadata.setLabels(TillerInstaller.normalizeLabels(labels));
        podTemplateSpec.setMetadata(metadata);
        PodSpec podSpec = new PodSpec();
        podSpec.setServiceAccountName(TillerInstaller.normalizeServiceAccountName(serviceAccountName));
        podSpec.setContainers(Arrays.asList(this.createContainer(imageName, imagePullPolicy, maxHistory, namespace, tls, verifyTls)));
        podSpec.setHostNetwork(Boolean.valueOf(hostNetwork));
        if (nodeSelector != null && !nodeSelector.isEmpty()) {
            podSpec.setNodeSelector(nodeSelector);
        }
        if (tls) {
            Volume volume = new Volume();
            volume.setName("tiller-certs");
            SecretVolumeSource secretVolumeSource = new SecretVolumeSource();
            secretVolumeSource.setSecretName(SECRET_NAME);
            volume.setSecret(secretVolumeSource);
            podSpec.setVolumes(Arrays.asList(volume));
        }
        podTemplateSpec.setSpec(podSpec);
        deploymentSpec.setTemplate(podTemplateSpec);
        return deploymentSpec;
    }

    protected Container createContainer(String imageName, ImagePullPolicy imagePullPolicy, String namespace, boolean tls, boolean verifyTls) {
        return this.createContainer(imageName, imagePullPolicy, 0, namespace, tls, verifyTls);
    }

    protected Container createContainer(String imageName, ImagePullPolicy imagePullPolicy, int maxHistory, String namespace, boolean tls, boolean verifyTls) {
        Container container = new Container();
        container.setName(DEFAULT_NAME);
        container.setImage(TillerInstaller.normalizeImageName(imageName));
        container.setImagePullPolicy(TillerInstaller.normalizeImagePullPolicy(imagePullPolicy));
        ArrayList<ContainerPort> containerPorts = new ArrayList<ContainerPort>(2);
        ContainerPort containerPort = new ContainerPort();
        containerPort.setContainerPort(Integer.valueOf(44134));
        containerPort.setName(DEFAULT_NAME);
        containerPorts.add(containerPort);
        containerPort = new ContainerPort();
        containerPort.setContainerPort(Integer.valueOf(44135));
        containerPort.setName("http");
        containerPorts.add(containerPort);
        container.setPorts(containerPorts);
        ArrayList<EnvVar> env = new ArrayList<EnvVar>();
        EnvVar tillerNamespace = new EnvVar();
        tillerNamespace.setName("TILLER_NAMESPACE");
        tillerNamespace.setValue(this.normalizeNamespace(namespace));
        env.add(tillerNamespace);
        EnvVar tillerHistoryMax = new EnvVar();
        tillerHistoryMax.setName("TILLER_HISTORY_MAX");
        tillerHistoryMax.setValue(String.valueOf(maxHistory));
        env.add(tillerHistoryMax);
        if (tls) {
            EnvVar tlsVerify = new EnvVar();
            tlsVerify.setName("TILLER_TLS_VERIFY");
            tlsVerify.setValue(verifyTls ? "1" : "");
            env.add(tlsVerify);
            EnvVar tlsEnable = new EnvVar();
            tlsEnable.setName("TILLER_TLS_ENABLE");
            tlsEnable.setValue("1");
            env.add(tlsEnable);
            EnvVar tlsCerts = new EnvVar();
            tlsCerts.setName("TILLER_TLS_CERTS");
            tlsCerts.setValue(TILLER_TLS_CERTS_PATH);
            env.add(tlsCerts);
        }
        container.setEnv(env);
        IntOrString port44135 = new IntOrString(Integer.valueOf(44135));
        HTTPGetAction livenessHttpGetAction = new HTTPGetAction();
        livenessHttpGetAction.setPath("/liveness");
        livenessHttpGetAction.setPort(port44135);
        Probe livenessProbe = new Probe();
        livenessProbe.setHttpGet(livenessHttpGetAction);
        livenessProbe.setInitialDelaySeconds(ONE);
        livenessProbe.setTimeoutSeconds(ONE);
        container.setLivenessProbe(livenessProbe);
        HTTPGetAction readinessHttpGetAction = new HTTPGetAction();
        readinessHttpGetAction.setPath("/readiness");
        readinessHttpGetAction.setPort(port44135);
        Probe readinessProbe = new Probe();
        readinessProbe.setHttpGet(readinessHttpGetAction);
        readinessProbe.setInitialDelaySeconds(ONE);
        readinessProbe.setTimeoutSeconds(ONE);
        container.setReadinessProbe(readinessProbe);
        if (tls) {
            VolumeMount volumeMount = new VolumeMount();
            volumeMount.setName("tiller-certs");
            volumeMount.setReadOnly(Boolean.valueOf(true));
            volumeMount.setMountPath(TILLER_TLS_CERTS_PATH);
            container.setVolumeMounts(Arrays.asList(volumeMount));
        }
        return container;
    }

    protected ServiceSpec createServiceSpec(Map<String, String> labels) {
        ServiceSpec serviceSpec = new ServiceSpec();
        serviceSpec.setType("ClusterIP");
        ServicePort servicePort = new ServicePort();
        servicePort.setName(DEFAULT_NAME);
        servicePort.setPort(Integer.valueOf(44134));
        servicePort.setTargetPort(new IntOrString(DEFAULT_NAME));
        serviceSpec.setPorts(Arrays.asList(servicePort));
        serviceSpec.setSelector(TillerInstaller.normalizeLabels(labels));
        return serviceSpec;
    }

    protected final String normalizeNamespace(String namespace) {
        if ((namespace == null || namespace.isEmpty()) && ((namespace = this.tillerNamespace) == null || namespace.isEmpty())) {
            namespace = DEFAULT_NAMESPACE;
        }
        return namespace;
    }

    protected final <T extends HttpClientAware & KubernetesClient> void ping(String namespace, Map<String, String> labels, long timeoutInMilliseconds) throws MalformedURLException {
        if (timeoutInMilliseconds >= 0L && this.kubernetesClient instanceof HttpClientAware) {
            if (!this.isTillerPodReady(namespace = this.normalizeNamespace(namespace), labels, timeoutInMilliseconds)) {
                throw new TillerPollingDeadlineExceededException(String.valueOf(timeoutInMilliseconds));
            }
            Tiller tiller = new Tiller((HttpClientAware)this.kubernetesClient, namespace, -1, labels);
            HealthGrpc.HealthBlockingStub health = tiller.getHealthBlockingStub();
            assert (health != null);
            HealthCheckRequest.Builder builder = HealthCheckRequest.newBuilder();
            assert (builder != null);
            builder.setService("Tiller");
            HealthCheckResponse response = health.check(builder.build());
            assert (response != null);
            HealthCheckResponse.ServingStatus status = response.getStatus();
            assert (status != null);
            switch (status) {
                case SERVING: {
                    break;
                }
                default: {
                    throw new TillerNotAvailableException(String.valueOf(status));
                }
            }
        }
    }

    protected final boolean isTillerPodReady(String namespace, Map<String, String> labels, long timeoutInMilliseconds) {
        namespace = this.normalizeNamespace(namespace);
        labels = TillerInstaller.normalizeLabels(labels);
        Object[] podHolder = new Object[1];
        Listable podList = (Listable)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withLabels(labels);
        Thread thread = new Thread(() -> {
            while ((podHolder[0] = Pods.getFirstReadyPod((Listable)podList)) == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        });
        thread.start();
        try {
            thread.join(timeoutInMilliseconds);
        }
        catch (InterruptedException timeExpired) {
            Thread.currentThread().interrupt();
        }
        boolean returnValue = podHolder[0] != null;
        return returnValue;
    }

    protected static final Map<String, String> normalizeLabels(Map<String, String> labels) {
        if (labels == null) {
            labels = new HashMap<String, String>(7);
        }
        if (!labels.containsKey("app")) {
            labels.put("app", "helm");
        }
        if (!labels.containsKey("name")) {
            labels.put("name", DEFAULT_NAME);
        }
        return labels;
    }

    protected static final String normalizeDeploymentName(String deploymentName) {
        if (deploymentName == null || deploymentName.isEmpty()) {
            return DEFAULT_DEPLOYMENT_NAME;
        }
        return deploymentName;
    }

    protected static final String normalizeImageName(String imageName) {
        if (imageName == null || imageName.isEmpty()) {
            return DEFAULT_IMAGE_NAME;
        }
        return imageName;
    }

    private static final String normalizeImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        if (imagePullPolicy == null) {
            imagePullPolicy = DEFAULT_IMAGE_PULL_POLICY;
        }
        assert (imagePullPolicy != null);
        return imagePullPolicy.toString();
    }

    protected static final String normalizeServiceAccountName(String serviceAccountName) {
        return serviceAccountName == null ? "" : serviceAccountName;
    }

    protected static final String normalizeServiceName(String serviceName) {
        if (serviceName == null || serviceName.isEmpty()) {
            return DEFAULT_DEPLOYMENT_NAME;
        }
        return serviceName;
    }

    private static final InputStream read(URI uri) throws IOException {
        BufferedInputStream returnValue;
        if (uri == null) {
            returnValue = null;
        } else {
            URL url = uri.toURL();
            assert (url != null);
            InputStream uriStream = url.openStream();
            returnValue = uriStream == null ? null : (uriStream instanceof BufferedInputStream ? (BufferedInputStream)uriStream : new BufferedInputStream(uriStream));
        }
        return returnValue;
    }

    private static final byte[] toByteArray(InputStream inputStream) throws IOException {
        byte[] returnValue = null;
        if (inputStream != null) {
            int bytesRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            returnValue = new byte[4096];
            while ((bytesRead = inputStream.read(returnValue, 0, returnValue.length)) != -1) {
                buffer.write(returnValue, 0, bytesRead);
            }
            buffer.flush();
            returnValue = buffer.toByteArray();
        }
        return returnValue;
    }

    private static final boolean isServerTillerVersionGreaterThanClientTillerVersion(String serverTillerImage) {
        boolean returnValue = false;
        if (serverTillerImage != null) {
            String versionSpecifier;
            Matcher matcher = TILLER_VERSION_PATTERN.matcher(serverTillerImage);
            assert (matcher != null);
            if (matcher.find() && (versionSpecifier = matcher.group(1)) != null) {
                Version serverTillerVersion = Version.valueOf((String)versionSpecifier);
                assert (serverTillerVersion != null);
                Version clientTillerVersion = Version.valueOf((String)VERSION);
                assert (clientTillerVersion != null);
                returnValue = serverTillerVersion.compareTo(clientTillerVersion) > 0;
            }
        }
        return returnValue;
    }

    public static enum ImagePullPolicy {
        ALWAYS("Always"),
        IF_NOT_PRESENT("IfNotPresent"),
        NEVER("Never");

        private final String value;

        private ImagePullPolicy(String value) {
            Objects.requireNonNull(value);
            this.value = value;
        }

        public final String toString() {
            return this.value;
        }
    }
}

