package common.kubernetes.convertvalue;

import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ArrayUtils;

import common.kubernetes.helm.HelmClient;
import common.kubernetes.helm.HelmCmd;
import common.kubernetes.helm.HelmFlags;
import common.kubernetes.helm.IConvertParams;
import common.kubernetes.helm.po.HelmInst;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.callback.IConvertValue;

@Slf4j
public class ConvertValueHelmStatus<T> implements IConvertValue<T> {
	private final IConvertParams<T> packer;
	private final String nameForNameCol;

	public ConvertValueHelmStatus(IConvertParams<T> packer, String nameForNameCol) {
		this.packer = packer;
		this.nameForNameCol = nameForNameCol;
	}

	@Override
	public String getStr(T keyObj) {
		Map<HelmFlags, String> values = this.packer.pack(keyObj);
		Result call = HelmClient.call(HelmCmd.list, values);
		if(!call.isSuc()) {
			return  "异常";//call.getMessage();
		}
		if(ArrayUtils.isEmpty(call.retObjs())) {
			return "未部署";
		}		
		for (Object obj : call.retObjs()) {
			HelmInst helmInst = (HelmInst) obj;
			try {
				if (helmInst.getName().equals(BeanUtils.getProperty(keyObj, nameForNameCol))) {
					return helmInst.getStatus();
				}
			} catch (Exception e) {
				log.error("转换失败", e);
			}
		}
		return "未部署";
	}

}
