/*
 * Decompiled with CFR 0.152.
 */
package common.kubernetes.apiserver;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import common.kubernetes.apiserver.ApiClientCreator;
import common.kubernetes.apiserver.ApiClientManager;
import common.kubernetes.constant.CrdVesion;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.util.Yaml;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.FreemarkUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.yaml.YamlAssist;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

public class KubeClientTams {
    private final DefaultKubernetesClient client;
    private final ApiClient apiClient;

    public DefaultKubernetesClient getClient() {
        return this.client;
    }

    public KubeClientTams() {
        this.client = this.initClient();
        this.apiClient = ApiClientManager.getApiClient();
    }

    public KubeClientTams(String kubeconfigstr, String context) {
        this.client = this.getClientForKube(kubeconfigstr, context);
        this.apiClient = new ApiClientCreator(kubeconfigstr, context).createObject();
    }

    public KubeClientTams(String pathTypePath) {
        String kubeconfigstr = IOUtil.slurpPathTypePath((String)pathTypePath);
        this.client = this.getClientForKube(kubeconfigstr, null);
        this.apiClient = new ApiClientCreator(kubeconfigstr, null).createObject();
    }

    public KubeClientTams(DefaultKubernetesClient client, ApiClient apiClient) {
        this.client = client;
        this.apiClient = apiClient;
    }

    private DefaultKubernetesClient initClient() {
        DefaultKubernetesClient client = null;
        if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.kubeconfig.path"))) {
            String kubeconfigstr = IOUtil.slurp((String)Conf.get((String)"common.kubernetes.kubeconfig.path"));
            String context = IOUtil.slurp((String)Conf.get((String)"common.kubernetes.kubeconfig.context"));
            client = this.getClientForKube(kubeconfigstr, context);
        } else if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.apiserver.master.url"))) {
            ConfigBuilder config = (ConfigBuilder)new ConfigBuilder().withMasterUrl(Conf.get((String)"common.kubernetes.apiserver.master.url"));
            if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.apiserver.master.username"))) {
                config.withUsername(Conf.get((String)"common.kubernetes.apiserver.master.username"));
                config.withPassword(Conf.get((String)"common.kubernetes.apiserver.master.password"));
            }
            config.withTrustCerts(true);
            client = new DefaultKubernetesClient(config.build());
        } else {
            client = new DefaultKubernetesClient();
        }
        return client;
    }

    private DefaultKubernetesClient getClientForKube(String kubeconfigstr, String context) {
        try {
            Config config = StringUtil.isNull((Object)context) ? Config.fromKubeconfig((String)kubeconfigstr) : Config.fromKubeconfig((String)context, (String)kubeconfigstr, null);
            DefaultKubernetesClient client = new DefaultKubernetesClient(config);
            return client;
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_conn_error, "", (Throwable)e);
        }
    }

    private String getUseNamespaceName(String namespace) {
        String namespaceTrue = StringUtil.isNull((Object)namespace) ? Conf.get((String)"common.kubernetes.apiserver.namespace.default") : namespace;
        return namespaceTrue;
    }

    public Namespace getNamespace(String namespace) {
        Namespace myns = (Namespace)((Resource)this.client.namespaces().withName(namespace)).get();
        return myns;
    }

    public ServiceList getServices(String namespace) {
        ServiceList myNsServices = (ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).list();
        return myNsServices;
    }

    public ServiceList getServices() {
        return this.getServices(null);
    }

    public Service getService(String namespace, String serviceName) {
        Service myservice = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(serviceName)).get();
        return myservice;
    }

    public Map<String, Object> createCusObject(CrdVesion crdVesion, String version, String namespace, InputStream fileInputStream) {
        try {
            CustomResourceDefinitionContext context = crdVesion.getCrdByVersion(version);
            Map dummyObject = this.client.customResource(context).load(fileInputStream);
            Map map = this.client.customResource(context).create(namespace, dummyObject);
            return map;
        }
        catch (IOException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
        catch (Throwable e) {
            if (e.getMessage().contains("404 page not found")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_pagenotfound, "\u6ca1\u6709\u5e03\u7f72api:" + e.getMessage());
            }
            if (e.getMessage().contains("already exists")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_exists, "\u5df2\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u540c\u540d\u8d44\u6e90:" + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
    }

    public Map<String, Object> createCusObject(CrdVesion crdVesion, String namespace, InputStream fileInputStream) {
        return this.createCusObject(crdVesion, null, namespace, fileInputStream);
    }

    public Map<String, Object> deleteCusObject(CrdVesion crdVesion, String version, String namespace, String name) {
        try {
            CustomResourceDefinitionContext context = crdVesion.getCrdByVersion(version);
            Map map = this.client.customResource(context).delete(namespace, name);
            return map;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 404) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_pagenotfound, "\u6ca1\u6709\u5e03\u7f72\u5e94\u7528:" + name + ": " + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
        catch (Throwable e) {
            if (e.getMessage().contains("already exists")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_exists, "\u5df2\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u540c\u540d\u8d44\u6e90:" + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
    }

    public Map<String, Object> deleteCusObject(CrdVesion crdVesion, String namespace, String name) {
        return this.deleteCusObject(crdVesion, null, namespace, name);
    }

    public Map<String, Object> selCusObject(CrdVesion crdVesion, String version, String namespace, String name) {
        CustomResourceDefinitionContext context = crdVesion.getCrdByVersion(version);
        Map map = null;
        if (StringUtil.isNotNull((Object)namespace) && StringUtil.isNotNull((Object)name)) {
            map = this.client.customResource(context).get(namespace, name);
        } else if (StringUtil.isNotNull((Object)namespace) && StringUtil.isNull((Object)name)) {
            map = this.client.customResource(context).list(namespace);
        } else if (StringUtil.isNull((Object)namespace) && StringUtil.isNotNull((Object)name)) {
            map = this.client.customResource(context).get(name);
        } else if (StringUtil.isNull((Object)namespace) && StringUtil.isNull((Object)name)) {
            map = this.client.customResource(context).list();
        }
        return map;
    }

    public Service getService(String serviceName) {
        return this.getService(null, serviceName);
    }

    public ReplicationController getRC(String namespace, String rcName) {
        ReplicationController gotRc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).get();
        return gotRc;
    }

    public ReplicationController getRC(String rcName) {
        return this.getRC(null, rcName);
    }

    public Service getSVC(String namespace, String rcName) {
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).get();
        return service;
    }

    public String getRCYaml(String namespace, String rcName) throws JsonProcessingException {
        ReplicationController gotRc = this.getRC(namespace, rcName);
        String str = SerializationUtils.dumpAsYaml((HasMetadata)gotRc);
        return str;
    }

    public boolean delService(String namespace, String serviceName) {
        Boolean optResult = (Boolean)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(serviceName)).delete();
        return optResult;
    }

    public boolean delService(String serviceName) {
        return this.delService(null, serviceName);
    }

    public Result createNamespace(String namespace) {
        try {
            Namespace namespaceRet = (Namespace)this.client.namespaces().create((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespace)).endMetadata()).build());
            return Result.getSuc().setRetObjs((Object[])new Namespace[]{namespaceRet});
        }
        catch (Exception e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public Result delNamespace(String namespace) {
        Boolean retobj = (Boolean)((Resource)this.client.namespaces().withName("test")).delete();
        if (retobj != null && retobj.booleanValue()) {
            return Result.getSuc();
        }
        return Result.getError((String)"\u5220\u9664\u540d\u5b57\u7a7a\u95f4\u5931\u8d25");
    }

    public boolean delPodByName(String namespace, String podName) {
        return (Boolean)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.getUseNamespaceName(namespace))).withName(podName)).delete();
    }

    public boolean delPodByName(String podName) {
        return this.delPodByName(null, podName);
    }

    public boolean delPodByLabel(String namespace, String key, String value) {
        return (Boolean)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.getUseNamespaceName(namespace))).withLabel(key, value)).delete();
    }

    public boolean delPodByLabel(String key, String value) {
        return this.delPodByLabel(null, key, value);
    }

    public void createRc(String namespace, String filePath) throws ProjectException {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.createRc(namespace, inputstream);
    }

    public void createRc(String namespace, FileInputStream fileInputStream) throws ProjectException {
        JSONObject jsonObject = YamlAssist.readYaml((FileInputStream)fileInputStream);
        ReplicationController rc = (ReplicationController)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).create((Object[])new ReplicationController[0]);
        if (jsonObject.containsKey((Object)"metadata")) {
            JSONObject metadataJson = jsonObject.getJSONObject("metadata");
            if (!metadataJson.containsKey((Object)"name")) {
                throw new ProjectException((IExcept)ExceptAll.param_error, "metadata\u9700\u8981\u6709name\u5143\u7d20");
            }
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName(metadataJson.getString("name"));
            if (metadataJson.containsKey((Object)"labels")) {
                JSONObject labels = metadataJson.getJSONObject("labels");
                HashMap<String, String> lables = new HashMap<String, String>();
                for (String key : labels.keySet()) {
                    lables.put(key, labels.getString(key));
                }
                metadata.setLabels(lables);
            }
            rc.setMetadata(metadata);
        }
        JSONObject specJson = jsonObject.getJSONObject("spec");
        ReplicationControllerSpec spec = rc.getSpec();
        if (specJson.containsKey((Object)"replicas")) {
            spec.setReplicas(specJson.getInteger("replicas"));
        }
        if (specJson.containsKey((Object)"selector")) {
            Map selector = (Map)JSONObject.toJavaObject((JSON)specJson.getJSONObject("selector"), Map.class);
            spec.setSelector(selector);
        }
        PodTemplateSpec newTemplate = spec.getTemplate();
        JSONObject templateJson = specJson.getJSONObject("template");
        if (templateJson.containsKey((Object)"metadata")) {
            ObjectMeta withNewMetadata = newTemplate.getMetadata();
            JSONObject jsonObject2 = templateJson.getJSONObject("metadata").getJSONObject("labels");
            Map labels = (Map)JSON.toJavaObject((JSON)jsonObject2, Map.class);
            withNewMetadata.setLabels(labels);
        }
        JSONObject innerSpecJson = templateJson.getJSONObject("spec");
        JSONArray containersJson = innerSpecJson.getJSONArray("containers");
        for (int i = 0; i < containersJson.size(); ++i) {
            JSONObject containerJson = containersJson.getJSONObject(i);
            Container addNewContainer = new Container();
            addNewContainer.setName(containerJson.getString("name"));
            addNewContainer.setImage(containerJson.getString("image"));
            JSONArray portAry = containerJson.getJSONArray("ports");
            ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
            for (int j = 0; j < portAry.size(); ++j) {
                ContainerPort temport = new ContainerPort();
                temport.setContainerPort(portAry.getJSONObject(i).getInteger("containerPort"));
                ports.add(temport);
            }
            addNewContainer.setPorts(ports);
        }
    }

    public void createSvc(String namespace, FileInputStream fileInputStream) throws ProjectException {
        JSONObject jsonObject = YamlAssist.readYaml((FileInputStream)fileInputStream);
        Service createNew = (Service)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).create((Object[])new Service[0]);
        JSONObject metadata = jsonObject.getJSONObject("metadata");
        ObjectMeta meta = new ObjectMeta();
        meta.setName(metadata.getString("name"));
        createNew.setMetadata(meta);
        JSONObject specjson = jsonObject.getJSONObject("spec");
        ServiceSpec withNewSpec = createNew.getSpec();
        if (specjson.containsKey((Object)"type")) {
            withNewSpec.setType(specjson.getString("type"));
        }
        if (specjson.containsKey((Object)"selector")) {
            Map seleMap = (Map)JSON.toJavaObject((JSON)specjson.getJSONObject("selector"), Map.class);
            withNewSpec.setSelector(seleMap);
        }
        if (specjson.containsKey((Object)"ports")) {
            JSONArray array = specjson.getJSONArray("ports");
            ArrayList<ServicePort> ports = new ArrayList<ServicePort>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject tempobj = array.getJSONObject(i);
                ServicePort temp = new ServicePort();
                if (tempobj.containsKey((Object)"name")) {
                    temp.setName(tempobj.getString("name"));
                }
                if (tempobj.containsKey((Object)"nodePort")) {
                    temp.setNodePort(tempobj.getInteger("nodePort"));
                }
                if (tempobj.containsKey((Object)"port")) {
                    temp.setPort(tempobj.getInteger("port"));
                }
                if (tempobj.containsKey((Object)"protocol")) {
                    temp.setProtocol(tempobj.getString("protocol"));
                }
                if (tempobj.containsKey((Object)"targetPort")) {
                    IntOrString input = new IntOrString(tempobj.getInteger("targetPort"));
                    temp.setTargetPort(input);
                }
                ports.add(temp);
            }
            withNewSpec.setPorts(ports);
        }
    }

    public void createSvc(String namespace, String filePath) throws ProjectException {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.createSvc(namespace, inputstream);
    }

    public void createResourcequota(String namespace, int minCpu, int minMemory, int maxCpu, int maxMemory, int pods) {
        HashMap<String, Quantity> parma = new HashMap<String, Quantity>();
        parma.put("pods", new Quantity(String.valueOf(pods)));
        parma.put("requests.cpu", new Quantity(String.valueOf(minCpu)));
        parma.put("requests.memory", new Quantity(String.valueOf(minMemory)));
        parma.put("limits.cpu", new Quantity(String.valueOf(maxCpu)));
        parma.put("limits.memory", new Quantity(String.valueOf(maxMemory)));
        ResourceQuota quota = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(this.getUseNamespaceName(namespace))).endMetadata()).withNewSpec().addToHard(parma)).endSpec()).build();
        ((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(this.getUseNamespaceName(namespace))).create((Object)quota);
    }

    public void delResourcequota(String namespace) {
        ((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(this.getUseNamespaceName(namespace))).delete();
    }

    public boolean delRc(String namespace, String rcName) {
        return (Boolean)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).delete();
    }

    public boolean delSvc(String namespace, String svcName) {
        return (Boolean)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withField("metadata.name", svcName)).delete();
    }

    public void updateRcImage(String namespace, String rcName, int containerIndex, String imageValue) {
        ReplicationControllerSpec spec = ((DoneableReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).edit()).getSpec();
        Container container = (Container)spec.getTemplate().getSpec().getContainers().get(containerIndex);
        container.setImage(imageValue);
    }

    public Result updateImageRolling(String namespace, String rcName, String imageValue) {
        try {
            ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(namespace)).withName(rcName)).rolling()).updateImage(imageValue);
            return Result.getSuc();
        }
        catch (Exception e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public Result createOrUpdateImageRolling(String namespace, String imageValue, String rcPath) {
        JSONObject json = YamlAssist.readYaml((String)rcPath);
        String rcName = json.getJSONObject("metadata").getString("name");
        ReplicationController queryRc = this.getRC(namespace, rcName);
        if (queryRc == null) {
            try {
                this.createRc(namespace, rcPath);
                return Result.getSuc();
            }
            catch (ProjectException e) {
                return Result.getError((String)e.getMessage());
            }
        }
        return this.updateImageRolling(namespace, rcName, imageValue);
    }

    public Deployment getDeploymentByName(String namespace, String name) {
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withName(name)).get();
        return deployment;
    }

    public Deployment getDeploymentByLabelOne(String namespace, String label, String value) {
        DeploymentList list = this.getDeploymentByLabel(namespace, label, value);
        if (list == null || list.getItems().size() != 1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_notfit, "Deployment\u9884\u671f\u53ea\u6709\u4e00\u4e2a\uff0c\u73b0\u5df2\u67e5\u51fa:" + list.getItems().size());
        }
        return (Deployment)list.getItems().get(0);
    }

    public DeploymentList getDeploymentByLabel(String namespace, String label, String value) {
        DeploymentList deployments = (DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withLabel(label, value)).list();
        return deployments;
    }

    public DeploymentList getDeploymentByLabel(String namespace, String label) {
        DeploymentList deployments = (DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withLabel(label)).list();
        return deployments;
    }

    public V1Deployment installDeploymentByTemp(String namespace, String context, Map<String, Object> params) {
        try {
            String result = FreemarkUtil.getInst().doProcessByTemp(context, params);
            V1Deployment yamlSvc = (V1Deployment)Yaml.load((String)result);
            AppsV1Api appsV1Api = new AppsV1Api(this.apiClient);
            V1Deployment v1Deployment = appsV1Api.createNamespacedDeployment(namespace, yamlSvc, "true", null, null);
            return v1Deployment;
        }
        catch (ApiException e) {
            if ("Conflict".equals(e.getMessage())) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_deploy_conflict);
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, e.getMessage());
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_deploy_excetion, "\u90e8\u7f72task\u5931\u8d25", (Throwable)e);
        }
    }
}

