package common.kubernetes.helm.po;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.apiext.StringUtil;

/**
 * list会组装为此对象
 * 
 * @author Andy
 *
 */
@Data
@Slf4j
public class HelmInst {
	private String name;
	private String namespace;
	private String revesion;
	private Date updated;
	private String status;
	private String chart;
	private String appVersion;

	public static List<HelmInst> splitList(String value) {
		String[] rows = value.split("\n");
		List<HelmInst> retlist = new ArrayList<HelmInst>();
		if (rows.length > 1) {// 第一行是：NAME NAMESPACE REVISION UPDATED STATUS CHART APP VERSION
			for (int i = 1; i < rows.length; i++) {
				if (rows[i].startsWith("WARNING: ")) {// WARNING: Kubernetes configuration file is world-readable. This
														// is insecure. Location: ***
					continue;// 警告信息不理
				}
				String[] row = rows[i].split("\t");
				if (row.length < 7) {
					log.error("此结果不能被解析：" + rows[i]);
					continue;
				} else {
					log.info("返回值:" + rows[i]);
				}
				HelmInst temp = new HelmInst();
				temp.setName(StringUtil.trimSpace(row[0]));
				temp.setNamespace(StringUtil.trimSpace(row[1]));
				temp.setRevesion(StringUtil.trimSpace(row[2]));
				try {
					temp.setUpdated(DateUtil.objToDate(StringUtil.trimSpace(row[3]).subSequence(0, 19)));
				} catch (Throwable e) {
				}
				temp.setStatus(StringUtil.trimSpace(row[4]));
				temp.setChart(StringUtil.trimSpace(row[5]));
				temp.setAppVersion(StringUtil.trimSpace(row[6]));
				retlist.add(temp);
			}
		}
		return retlist;
	}
}
