package common.kubernetes.constant;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

/***
 * k8s的资源类型
 * 
 * @author andy.zhou
 * 
 */
public enum CrdVesion implements IEnumCombobox {
	flink("流计算flink", "flink", "cn.linkedcare", "flinkapps.cn.linkedcare", "flinkapps", "Namespaced", "FlinkApp",
			new String[] { "flink" }, new String[] { "v1alpha1", "v1-14-0" });

	private final String desc;
	private final String desc_en;
	private final String group;
	private final String crdName;
	private final String plural;
	private final String scope;
	private final String kind;
	private final String[] shortNames;
	private final String[] versions;

	public String[] getVersions() {
		return versions;
	}

	private CrdVesion(String desc, String desc_en, String group, String crdName, String plural, String scope,
			String kind, String[] shortNames, String[] versions) {
		this.desc = desc;
		this.desc_en = desc_en;
		this.versions = versions;
		this.group = group;
		this.crdName = crdName;
		this.plural = plural;
		this.scope = scope;
		this.kind = kind;
		this.shortNames = shortNames;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.desc_en;
	}

	public String getGroup() {
		return group;
	}

	public String getPlural() {
		return plural;
	}

	public String getScope() {
		return scope;
	}

	public String getCrdName() {
		return crdName;
	}

	public String getKind() {
		return kind;
	}

	public String[] getShortNames() {
		return shortNames;
	}

	public static CrdVesion find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (CrdVesion ele : CrdVesion.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

	/**
	 * 版本是api的一部分，必需要有
	 * 
	 * @param version
	 * @return
	 */
	public CustomResourceDefinitionContext getCrdByVersion(String version) {
//		int indexOf = ArrayUtils.indexOf(this.versions, version);
//		if (indexOf < 0) {
//			throw new ProjectExceptionRuntime(ExceptAll.k8s_api_versionnotexit, "不存在这个版本:" + version);
//		}
		// 版本影响不大，跳过处理，暂不处理版本相关信息
		int indexOf = 0;
		CustomResourceDefinitionContext context = new CustomResourceDefinitionContext.Builder()
				.withGroup(this.getGroup())
				// .withKind("Dummy")
				.withName(this.getCrdName()).withPlural(this.getPlural()).withScope(this.getScope())
				.withVersion(this.getVersions()[indexOf]).build();
		return context;
	}

}
