package common.kubernetes.apiserver;

import io.kubernetes.client.openapi.ApiClient;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

public abstract class ApiClientManager {

	public static ApiClient getApiClient(String idstr, String config) {
		ApiClient createObject = PerthreadManager.getInstance()
				.createValue("apiClientManager-" + idstr, new ApiClientCreator(config)).createObject();
		return createObject;
	}

	public static void cleanThread(String idstr) {
		PerthreadManager.getInstance().cleanValue("apiClientManager-" + StringUtil.hasNull(idstr, "default"));
	}

	public static ApiClient getApiClient() {
		ApiClient createObject = PerthreadManager.getInstance()
				.createValue("apiClientManager-default", new ApiClientCreator()).createObject();
		return createObject;
	}

	public static ApiClient getApiClientByPath(String idstr, String path) {
		String context = IOUtil.slurp(path);
		return getApiClient(idstr, context);
	}

}
