/*
 * Decompiled with CFR 0.152.
 */
package common.kubernetes.convertvalue;

import common.kubernetes.apiserver.KubeClientTams;
import common.kubernetes.constant.CrdVesion;
import io.fabric8.kubernetes.client.KubernetesClientException;
import java.util.Map;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertValueCrd<T>
implements IConvertValue<T> {
    private static final Logger log = LoggerFactory.getLogger(ConvertValueCrd.class);
    private final KubeClientTams kubeClientTams;
    private final CrdVesion crdVesion;
    private final String namespaceColName;
    private final String nameColName;
    private final ICallbackForConvertValueCrd<T> callback;

    public ConvertValueCrd(String pathTypePath, CrdVesion crdVesion, String namespaceColName, String nameColName) {
        this.callback = null;
        this.kubeClientTams = new KubeClientTams(pathTypePath);
        this.crdVesion = crdVesion;
        this.namespaceColName = namespaceColName;
        this.nameColName = nameColName;
    }

    public ConvertValueCrd(ICallbackForConvertValueCrd<T> callback, CrdVesion crdVesion, String namespaceColName, String nameColName) {
        this.callback = callback;
        this.kubeClientTams = null;
        this.crdVesion = crdVesion;
        this.namespaceColName = namespaceColName;
        this.nameColName = nameColName;
    }

    public String getStr(T keyObj) {
        try {
            KubeClientTams curClient = null;
            String ingress = null;
            if (this.callback != null) {
                curClient = new KubeClientTams(this.callback.getStr(keyObj));
                ingress = this.callback.getIngressJobmanager(keyObj);
            } else {
                curClient = this.kubeClientTams;
            }
            String namespace = BeanUtils.getProperty(keyObj, (String)this.namespaceColName);
            String name = BeanUtils.getProperty(keyObj, (String)this.nameColName);
            Map<String, Object> objs = curClient.selCusObject(this.crdVesion, namespace, name);
            if (MapUtils.isEmpty(objs)) {
                return "\u672a\u90e8\u7f72";
            }
            if (this.crdVesion == CrdVesion.flink && StringUtil.isNotNull((Object)ingress)) {
                return "<a href='https://" + ingress + "/" + name + "' target='_blank'>\u5df2\u90e8\u7f72</a>";
            }
            return "\u5df2\u90e8\u7f72";
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 404) {
                return "\u672a\u90e8\u7f72";
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2" + this.crdVesion.getCrdName() + "\u72b6\u6001\u5931\u8d25", (Throwable)e);
            return "\u5f02\u5e38";
        }
        return "\u672a\u90e8\u7f72";
    }

    public static interface ICallbackForConvertValueCrd<T> {
        public String getStr(T var1);

        public String getIngressJobmanager(T var1);
    }
}

