package common.kubernetes.convertvalue;

import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MapUtils;

import common.kubernetes.apiserver.KubeClientTams;
import common.kubernetes.constant.CrdVesion;
import io.fabric8.kubernetes.client.KubernetesClientException;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;

@Slf4j
public class ConvertValueCrd<T> implements IConvertValue<T> {
	private final KubeClientTams kubeClientTams;
	private final CrdVesion crdVesion;
	private final String namespaceColName;
	private final String nameColName;
	private final ICallbackForConvertValueCrd<T> callback;

	public ConvertValueCrd(String pathTypePath, CrdVesion crdVesion, String namespaceColName, String nameColName) {
		this.callback = null;
		this.kubeClientTams = new KubeClientTams(pathTypePath);
		this.crdVesion = crdVesion;
		this.namespaceColName = namespaceColName;
		this.nameColName = nameColName;
	}

	/***
	 * 
	 * @param callback         可以得到kubeconf的文件路径
	 * @param crdVesion
	 * @param namespaceColName
	 * @param nameColName
	 */
	public ConvertValueCrd(ICallbackForConvertValueCrd<T> callback, CrdVesion crdVesion, String namespaceColName,
			String nameColName) {
		this.callback = callback;
		this.kubeClientTams = null;
		this.crdVesion = crdVesion;
		this.namespaceColName = namespaceColName;
		this.nameColName = nameColName;
	}

	@Override
	public String getStr(T keyObj) {
		try {
			KubeClientTams curClient = null;
			String ingress=null;
			if (this.callback != null) {
				curClient = new KubeClientTams(this.callback.getStr(keyObj));
				ingress=this.callback.getIngressJobmanager(keyObj);
			} else {
				curClient = kubeClientTams;
			}

			String namespace = BeanUtils.getProperty(keyObj, namespaceColName);
			String name = BeanUtils.getProperty(keyObj, nameColName);
			Map<String, Object> objs = curClient.selCusObject(crdVesion, namespace, name);
			if (MapUtils.isEmpty(objs)) {
				return "未部署";
			} else {
				if (crdVesion == CrdVesion.flink && StringUtil.isNotNull(ingress)) {
					return "<a href='https://"+ingress+"/" + name + "' target='_blank'>已部署</a>";
				} else {
					return "已部署";
				}

			}
		} catch (KubernetesClientException e) {
			if (e.getCode() == 404) {
				return "未部署";
			}
		} catch (Exception e) {
			log.error("查询" + crdVesion.getCrdName() + "状态失败", e);
			return "异常";
		}
		// 需要对比。。。。。

		return "未部署";
	}
	
	
	public static interface ICallbackForConvertValueCrd<T>{
		/***
		 * 把对象转换成解释
		 * 
		 * @param keyObj
		 *            要解释的key
		 * @return 解释字符
		 */
		public String getStr(T keyObj);
		/**
		 * 得到jobmanager需要挂载的域名
		 * @param keyObj
		 * @return
		 */
		public String getIngressJobmanager(T keyObj);
	}

}
