/*
 * Decompiled with CFR 0.152.
 */
package org.microbean.helm.chart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;
import org.microbean.helm.chart.StreamOrientedChartLoader;

public class TapeArchiveChartLoader
extends StreamOrientedChartLoader<TarInputStream> {
    @Override
    protected Iterable<? extends Map.Entry<? extends String, ? extends InputStream>> toNamedInputStreamEntries(final TarInputStream stream) throws IOException {
        if (stream == null) {
            return new StreamOrientedChartLoader.EmptyIterable();
        }
        return new Iterable<Map.Entry<String, InputStream>>(){

            @Override
            public Iterator<Map.Entry<String, InputStream>> iterator() {
                return new Iterator<Map.Entry<String, InputStream>>(){
                    private TarEntry currentEntry;
                    {
                        try {
                            this.currentEntry = stream.getNextEntry();
                        }
                        catch (IOException ignore) {
                            this.currentEntry = null;
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currentEntry != null;
                    }

                    @Override
                    public Map.Entry<String, InputStream> next() {
                        AbstractMap.SimpleImmutableEntry<String, Object> returnValue;
                        if (this.currentEntry == null) {
                            throw new NoSuchElementException();
                        }
                        if (this.currentEntry.isDirectory()) {
                            returnValue = new AbstractMap.SimpleImmutableEntry<String, Object>(this.currentEntry.getName(), null);
                        } else {
                            ByteArrayInputStream bais = null;
                            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                                int bytesRead = 0;
                                byte[] bytes = new byte[4096];
                                while ((bytesRead = stream.read(bytes)) >= 0) {
                                    baos.write(bytes, 0, bytesRead);
                                }
                                baos.flush();
                                bais = new ByteArrayInputStream(baos.toByteArray());
                            }
                            catch (IOException wrapMe) {
                                throw (NoSuchElementException)new NoSuchElementException(wrapMe.getMessage()).initCause(wrapMe);
                            }
                            returnValue = new AbstractMap.SimpleImmutableEntry<String, ByteArrayInputStream>(this.currentEntry.getName(), bais);
                        }
                        try {
                            this.currentEntry = stream.getNextEntry();
                        }
                        catch (IOException ignore) {
                            this.currentEntry = null;
                        }
                        return returnValue;
                    }
                };
            }
        };
    }

    @Override
    public void close() throws IOException {
    }
}

