/*
 * Decompiled with CFR 0.152.
 */
package common.kubernetes.apiserver;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import common.kubernetes.constant.CrdVesion;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.yaml.YamlAssist;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubeClient {
    private static final Logger log = LoggerFactory.getLogger(KubeClient.class);

    public static DefaultKubernetesClient getClient() {
        DefaultKubernetesClient client = null;
        if (StringUtil.isNull((Object)Conf.get((String)"common.kubernetes.apiserver.master.url"))) {
            client = new DefaultKubernetesClient();
        } else {
            ConfigBuilder config = (ConfigBuilder)new ConfigBuilder().withMasterUrl(Conf.get((String)"common.kubernetes.apiserver.master.url"));
            if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.apiserver.master.username"))) {
                config.withUsername(Conf.get((String)"common.kubernetes.apiserver.master.username"));
                config.withPassword(Conf.get((String)"common.kubernetes.apiserver.master.password"));
            }
            config.withTrustCerts(true);
            client = new DefaultKubernetesClient(config.build());
        }
        return client;
    }

    private static String getUseNamespaceName(String namespace) {
        String namespaceTrue = StringUtil.isNull((Object)namespace) ? Conf.get((String)"common.kubernetes.apiserver.namespace.default") : namespace;
        return namespaceTrue;
    }

    public static Namespace getNamespace(String namespace) {
        Namespace myns = (Namespace)((Resource)KubeClient.getClient().namespaces().withName(namespace)).get();
        return myns;
    }

    public static ServiceList getServices(String namespace) {
        ServiceList myNsServices = (ServiceList)((NonNamespaceOperation)KubeClient.getClient().services().inNamespace(KubeClient.getUseNamespaceName(namespace))).list();
        return myNsServices;
    }

    public static ServiceList getServices() {
        return KubeClient.getServices(null);
    }

    public static Service getService(String namespace, String serviceName) {
        Service myservice = (Service)((ServiceResource)((NonNamespaceOperation)KubeClient.getClient().services().inNamespace(KubeClient.getUseNamespaceName(namespace))).withName(serviceName)).get();
        return myservice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> createCusObject(CrdVesion crdVesion, String namespace, InputStream fileInputStream) {
        try (DefaultKubernetesClient k8s = KubeClient.getClient();){
            Map map;
            CustomResourceDefinitionContext context = KubeClient.getFlinkCRD(crdVesion);
            Map dummyObject = k8s.customResource(context).load(fileInputStream);
            Map map2 = map = k8s.customResource(context).create(namespace, dummyObject);
            return map2;
        }
        catch (IOException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
        catch (Throwable e) {
            if (!e.getMessage().contains("404 page not found")) throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_pagenotfound, "\u6ca1\u6709\u5e03\u7f72api:" + e.getMessage());
        }
    }

    public static CustomResourceDefinitionContext getFlinkCRD(CrdVesion crdVesion) {
        CustomResourceDefinitionContext context = new CustomResourceDefinitionContext.Builder().withGroup(crdVesion.getGroup()).withName(crdVesion.getCrdName()).withPlural(crdVesion.getPlural()).withScope(crdVesion.getScope()).withVersion(crdVesion.getVersions()[0]).build();
        return context;
    }

    public static Service getService(String serviceName) {
        return KubeClient.getService(null, serviceName);
    }

    public static ReplicationController getRC(String namespace, String rcName) {
        ReplicationController gotRc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)KubeClient.getClient().replicationControllers().inNamespace(KubeClient.getUseNamespaceName(namespace))).withName(rcName)).get();
        return gotRc;
    }

    public static ReplicationController getRC(String rcName) {
        return KubeClient.getRC(null, rcName);
    }

    public static Service getSVC(String namespace, String rcName) {
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)KubeClient.getClient().services().inNamespace(KubeClient.getUseNamespaceName(namespace))).withName(rcName)).get();
        return service;
    }

    public static String getRCYaml(String namespace, String rcName) throws JsonProcessingException {
        ReplicationController gotRc = KubeClient.getRC(namespace, rcName);
        String str = SerializationUtils.dumpAsYaml((HasMetadata)gotRc);
        return str;
    }

    public static boolean delService(String namespace, String serviceName) {
        Boolean optResult = (Boolean)((ServiceResource)((NonNamespaceOperation)KubeClient.getClient().services().inNamespace(KubeClient.getUseNamespaceName(namespace))).withName(serviceName)).delete();
        return optResult;
    }

    public static boolean delService(String serviceName) {
        return KubeClient.delService(null, serviceName);
    }

    public static Result createNamespace(String namespace) {
        try {
            Namespace namespaceRet = (Namespace)KubeClient.getClient().namespaces().create((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespace)).endMetadata()).build());
            return Result.getSuc().setRetObjs((Object[])new Namespace[]{namespaceRet});
        }
        catch (Exception e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public static Result delNamespace(String namespace) {
        Boolean retobj = (Boolean)((Resource)KubeClient.getClient().namespaces().withName("test")).delete();
        if (retobj != null && retobj.booleanValue()) {
            return Result.getSuc();
        }
        return Result.getError((String)"\u5220\u9664\u540d\u5b57\u7a7a\u95f4\u5931\u8d25");
    }

    public static boolean delPodByName(String namespace, String podName) {
        return (Boolean)((PodResource)((NonNamespaceOperation)KubeClient.getClient().pods().inNamespace(KubeClient.getUseNamespaceName(namespace))).withName(podName)).delete();
    }

    public static boolean delPodByName(String podName) {
        return KubeClient.delPodByName(null, podName);
    }

    public static boolean delPodByLabel(String namespace, String key, String value) {
        return (Boolean)((FilterWatchListDeletable)((NonNamespaceOperation)KubeClient.getClient().pods().inNamespace(KubeClient.getUseNamespaceName(namespace))).withLabel(key, value)).delete();
    }

    public static boolean delPodByLabel(String key, String value) {
        return KubeClient.delPodByLabel(null, key, value);
    }

    public static void createRc(String namespace, String filePath) throws ProjectException {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        KubeClient.createRc(namespace, inputstream);
    }

    public static void createRc(String namespace, FileInputStream fileInputStream) throws ProjectException {
        JSONObject jsonObject = YamlAssist.readYaml((FileInputStream)fileInputStream);
        ReplicationController rc = (ReplicationController)((NonNamespaceOperation)KubeClient.getClient().replicationControllers().inNamespace(KubeClient.getUseNamespaceName(namespace))).create((Object[])new ReplicationController[0]);
        if (jsonObject.containsKey((Object)"metadata")) {
            JSONObject metadataJson = jsonObject.getJSONObject("metadata");
            if (!metadataJson.containsKey((Object)"name")) {
                throw new ProjectException((IExcept)ExceptAll.param_error, "metadata\u9700\u8981\u6709name\u5143\u7d20");
            }
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName(metadataJson.getString("name"));
            if (metadataJson.containsKey((Object)"labels")) {
                JSONObject labels = metadataJson.getJSONObject("labels");
                HashMap<String, String> lables = new HashMap<String, String>();
                for (String key : labels.keySet()) {
                    lables.put(key, labels.getString(key));
                }
                metadata.setLabels(lables);
            }
            rc.setMetadata(metadata);
        }
        JSONObject specJson = jsonObject.getJSONObject("spec");
        ReplicationControllerSpec spec = rc.getSpec();
        if (specJson.containsKey((Object)"replicas")) {
            spec.setReplicas(specJson.getInteger("replicas"));
        }
        if (specJson.containsKey((Object)"selector")) {
            Map selector = (Map)JSONObject.toJavaObject((JSON)specJson.getJSONObject("selector"), Map.class);
            spec.setSelector(selector);
        }
        PodTemplateSpec newTemplate = spec.getTemplate();
        JSONObject templateJson = specJson.getJSONObject("template");
        if (templateJson.containsKey((Object)"metadata")) {
            ObjectMeta withNewMetadata = newTemplate.getMetadata();
            JSONObject jsonObject2 = templateJson.getJSONObject("metadata").getJSONObject("labels");
            Map labels = (Map)JSON.toJavaObject((JSON)jsonObject2, Map.class);
            withNewMetadata.setLabels(labels);
        }
        PodSpec innerSpec = newTemplate.getSpec();
        JSONObject innerSpecJson = templateJson.getJSONObject("spec");
        JSONArray containersJson = innerSpecJson.getJSONArray("containers");
        for (int i = 0; i < containersJson.size(); ++i) {
            JSONObject containerJson = containersJson.getJSONObject(i);
            Container addNewContainer = new Container();
            addNewContainer.setName(containerJson.getString("name"));
            addNewContainer.setImage(containerJson.getString("image"));
            JSONArray portAry = containerJson.getJSONArray("ports");
            ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
            for (int j = 0; j < portAry.size(); ++j) {
                ContainerPort temport = new ContainerPort();
                temport.setContainerPort(portAry.getJSONObject(i).getInteger("containerPort"));
                ports.add(temport);
            }
            addNewContainer.setPorts(ports);
        }
    }

    public static void createSvc(String namespace, FileInputStream fileInputStream) throws ProjectException {
        JSONObject jsonObject = YamlAssist.readYaml((FileInputStream)fileInputStream);
        Service createNew = (Service)((NonNamespaceOperation)KubeClient.getClient().services().inNamespace(KubeClient.getUseNamespaceName(namespace))).create((Object[])new Service[0]);
        JSONObject metadata = jsonObject.getJSONObject("metadata");
        ObjectMeta meta = new ObjectMeta();
        meta.setName(metadata.getString("name"));
        createNew.setMetadata(meta);
        JSONObject specjson = jsonObject.getJSONObject("spec");
        ServiceSpec withNewSpec = createNew.getSpec();
        if (specjson.containsKey((Object)"type")) {
            withNewSpec.setType(specjson.getString("type"));
        }
        if (specjson.containsKey((Object)"selector")) {
            Map seleMap = (Map)JSON.toJavaObject((JSON)specjson.getJSONObject("selector"), Map.class);
            withNewSpec.setSelector(seleMap);
        }
        if (specjson.containsKey((Object)"ports")) {
            JSONArray array = specjson.getJSONArray("ports");
            ArrayList<ServicePort> ports = new ArrayList<ServicePort>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject tempobj = array.getJSONObject(i);
                ServicePort temp = new ServicePort();
                if (tempobj.containsKey((Object)"name")) {
                    temp.setName(tempobj.getString("name"));
                }
                if (tempobj.containsKey((Object)"nodePort")) {
                    temp.setNodePort(tempobj.getInteger("nodePort"));
                }
                if (tempobj.containsKey((Object)"port")) {
                    temp.setPort(tempobj.getInteger("port"));
                }
                if (tempobj.containsKey((Object)"protocol")) {
                    temp.setProtocol(tempobj.getString("protocol"));
                }
                if (tempobj.containsKey((Object)"targetPort")) {
                    IntOrString input = new IntOrString(tempobj.getInteger("targetPort"));
                    temp.setTargetPort(input);
                }
                ports.add(temp);
            }
            withNewSpec.setPorts(ports);
        }
    }

    public static void createSvc(String namespace, String filePath) throws ProjectException {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        KubeClient.createSvc(namespace, inputstream);
    }

    public static void createResourcequota(String namespace, int minCpu, int minMemory, int maxCpu, int maxMemory, int pods) {
        HashMap<String, Quantity> parma = new HashMap<String, Quantity>();
        parma.put("pods", new Quantity(String.valueOf(pods)));
        parma.put("requests.cpu", new Quantity(String.valueOf(minCpu)));
        parma.put("requests.memory", new Quantity(String.valueOf(minMemory)));
        parma.put("limits.cpu", new Quantity(String.valueOf(maxCpu)));
        parma.put("limits.memory", new Quantity(String.valueOf(maxMemory)));
        ResourceQuota quota = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(KubeClient.getUseNamespaceName(namespace))).endMetadata()).withNewSpec().addToHard(parma)).endSpec()).build();
        ((NonNamespaceOperation)KubeClient.getClient().resourceQuotas().inNamespace(KubeClient.getUseNamespaceName(namespace))).create((Object)quota);
    }

    public static void delResourcequota(String namespace) {
        ((NonNamespaceOperation)KubeClient.getClient().resourceQuotas().inNamespace(KubeClient.getUseNamespaceName(namespace))).delete();
    }

    public static boolean delRc(String namespace, String rcName) {
        return (Boolean)((RollableScalableResource)((NonNamespaceOperation)KubeClient.getClient().replicationControllers().inNamespace(KubeClient.getUseNamespaceName(namespace))).withName(rcName)).delete();
    }

    public static boolean delSvc(String namespace, String svcName) {
        return (Boolean)((FilterWatchListDeletable)((NonNamespaceOperation)KubeClient.getClient().services().inNamespace(KubeClient.getUseNamespaceName(namespace))).withField("metadata.name", svcName)).delete();
    }

    public static void updateRcImage(String namespace, String rcName, int containerIndex, String imageValue) {
        ReplicationControllerSpec spec = ((DoneableReplicationController)((RollableScalableResource)((NonNamespaceOperation)KubeClient.getClient().replicationControllers().inNamespace(KubeClient.getUseNamespaceName(namespace))).withName(rcName)).edit()).getSpec();
        Container container = (Container)spec.getTemplate().getSpec().getContainers().get(containerIndex);
        container.setImage(imageValue);
    }

    protected abstract Object setImage(String var1);

    public static Result updateImageRolling(String namespace, String rcName, String imageValue) {
        try {
            ((TimeoutImageEditReplacePatchable)((RollableScalableResource)((NonNamespaceOperation)KubeClient.getClient().replicationControllers().inNamespace(namespace)).withName(rcName)).rolling()).updateImage(imageValue);
            return Result.getSuc();
        }
        catch (Exception e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public static Result createOrUpdateImageRolling(String namespace, String imageValue, String rcPath) {
        JSONObject json = YamlAssist.readYaml((String)rcPath);
        String rcName = json.getJSONObject("metadata").getString("name");
        ReplicationController queryRc = KubeClient.getRC(namespace, rcName);
        if (queryRc == null) {
            try {
                KubeClient.createRc(namespace, rcPath);
                return Result.getSuc();
            }
            catch (ProjectException e) {
                return Result.getError((String)e.getMessage());
            }
        }
        return KubeClient.updateImageRolling(namespace, rcName, imageValue);
    }
}

