package common.kubernetes.constant;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * k8s的资源类型
 * 
 * @author andy.zhou
 * 
 */
public enum CrdVesion implements IEnumCombobox {
	flink("流计算flink", "flink", "flink.k8s.io", "flinkapplications.flink.k8s.io", "flinkapps", "Namespaced",
			"FlinkApplication", new String[] { "flinkapp" }, new String[] { "v1alpha1" });

	private final String desc;
	private final String desc_en;
	private final String group;
	private final String crdName;
	private final String plural;
	private final String scope;
	private final String kind;
	private final String[] shortNames;
	private final String[] versions;

	public String[] getVersions() {
		return versions;
	}

	private CrdVesion(String desc, String desc_en, String group, String crdName, String plural, String scope,
			String kind, String[] shortNames, String[] versions) {
		this.desc = desc;
		this.desc_en = desc_en;
		this.versions = versions;
		this.group = group;
		this.crdName = crdName;
		this.plural = plural;
		this.scope = scope;
		this.kind = kind;
		this.shortNames = shortNames;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.desc_en;
	}

	public String getGroup() {
		return group;
	}

	public String getPlural() {
		return plural;
	}

	public String getScope() {
		return scope;
	}

	public String getCrdName() {
		return crdName;
	}

	public String getKind() {
		return kind;
	}

	public String[] getShortNames() {
		return shortNames;
	}

	public static CrdVesion find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (CrdVesion ele : CrdVesion.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
