/*
 * Decompiled with CFR 0.152.
 */
package common.kubernetes.tiller;

import com.alibaba.fastjson.JSONObject;
import common.kubernetes.apiserver.KubeClient;
import common.kubernetes.constant.ResourcesType;
import hapi.chart.ChartOuterClass;
import hapi.release.ReleaseOuterClass;
import hapi.release.StatusOuterClass;
import hapi.services.tiller.ReleaseServiceGrpc;
import hapi.services.tiller.Tiller;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.grpc.ManagedChannel;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import org.apache.commons.lang3.Validate;
import org.microbean.helm.ReleaseManager;
import org.microbean.helm.Tiller;
import org.microbean.helm.chart.DirectoryChartLoader;
import org.microbean.helm.chart.URLChartLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class TillerClient {
    private static final Logger log = LoggerFactory.getLogger(TillerClient.class);
    private static TillerClient tillerClient = null;
    private final Tiller tiller;
    private final DirectoryChartLoader load = new DirectoryChartLoader();
    private final URLChartLoader urlLoader = new URLChartLoader();

    public Tiller getTiller() {
        return this.tiller;
    }

    private TillerClient() {
        if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.tiller.serverip"))) {
            ManagedChannel channel = NettyChannelBuilder.forAddress((String)Conf.get((String)"common.kubernetes.tiller.serverip"), (int)Conf.getInt((String)"common.kubernetes.tiller.port")).negotiationType(NegotiationType.PLAINTEXT).build();
            this.tiller = new Tiller(channel);
        } else {
            DefaultKubernetesClient client = KubeClient.getClient();
            try {
                this.tiller = new Tiller(client);
            }
            catch (MalformedURLException e) {
                log.error("error", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TillerClient getInst() {
        if (tillerClient != null) return tillerClient;
        Class<TillerClient> clazz = TillerClient.class;
        synchronized (TillerClient.class) {
            if (tillerClient != null) return tillerClient;
            tillerClient = new TillerClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return tillerClient;
        }
    }

    public void shutdown() {
        try {
            this.tiller.close();
            tillerClient = null;
        }
        catch (IOException e) {
            log.error("\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    public ReleaseServiceGrpc.ReleaseServiceBlockingStub getBlockingStub() {
        return this.tiller.getReleaseServiceBlockingStub();
    }

    public static void setValue(Tiller.InstallReleaseRequest.Builder requestBuilder, Object ... keyValues) {
        Map newMap = CollectionUtil.newMap((Object[])keyValues);
        JSONObject obj = JSONUtil.getJsonForMapFlat((Map)newMap);
        String yamlString = new Yaml().dump((Object)obj);
        requestBuilder.getValuesBuilder().setRaw(yamlString);
    }

    public ChartOuterClass.Chart.Builder chartBuilder(String chartsDirPath) {
        try {
            ChartOuterClass.Chart.Builder chartBuilder = this.load.load(Paths.get(chartsDirPath, new String[0]));
            return chartBuilder;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public Result installChart(String name, String namespace, ChartOuterClass.Chart.Builder chartBuilder, Object ... keyValues) {
        Tiller.InstallReleaseRequest.Builder requestBuilder = Tiller.InstallReleaseRequest.newBuilder();
        requestBuilder.setTimeout(300L);
        name = name.replace("_", "-");
        requestBuilder.setName(name);
        TillerClient.setValue(requestBuilder, keyValues);
        requestBuilder.setNamespace(namespace);
        requestBuilder.setWait(true);
        try {
            ReleaseManager chartManager = new ReleaseManager(this.tiller);
            Future<Tiller.InstallReleaseResponse> releaseFuture = chartManager.install(requestBuilder, chartBuilder);
            ReleaseOuterClass.Release release = releaseFuture.get().getRelease();
            if (release != null && StringUtil.isNotNull((Object)release.getName())) {
                return Result.getSuc();
            }
            return Result.getError((String)"\u90e8\u7f72\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u90e8\u7f72charts\u5931\u8d25:", (Throwable)e);
            return Result.getError((String)("\u90e8\u7f72\u5931\u8d25:" + e.getMessage()));
        }
    }

    public Result installDirChart(String name, String namespace, String chartsDirPath, Object ... keyValues) {
        ChartOuterClass.Chart.Builder chartBuilder = null;
        try {
            chartBuilder = this.load.load(Paths.get(chartsDirPath, new String[0]));
        }
        catch (Exception e) {
            log.error("\u76ee\u5f55\u3010" + chartsDirPath + "\u3011\u4e0d\u80fd\u8f6c\u4e3aChart\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u7684\u76ee\u5f55:", (Throwable)e);
            return Result.getError((String)("\u76ee\u5f55\u3010" + chartsDirPath + "\u3011\u4e0d\u80fd\u8f6c\u4e3aChart\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u7684\u76ee\u5f55:" + e.getMessage()));
        }
        return this.installChart(name, namespace, chartBuilder, keyValues);
    }

    public Result deleteChart(String name) {
        Tiller.UninstallReleaseRequest.Builder requestBuilder = Tiller.UninstallReleaseRequest.newBuilder();
        requestBuilder.setTimeout(300L);
        name = name.replace("_", "-");
        requestBuilder.setName(name);
        requestBuilder.setPurge(true);
        try {
            ReleaseManager chartManager = new ReleaseManager(this.tiller);
            Future<Tiller.UninstallReleaseResponse> releaseFuture = chartManager.uninstall(requestBuilder.build());
            Tiller.UninstallReleaseResponse release = releaseFuture.get();
            if (release != null && release.getRelease().getInfo().getStatus().getCode() == StatusOuterClass.Status.Code.DELETED) {
                return Result.getSuc();
            }
            return Result.getError((String)"\u5220\u9664chart\u5931\u8d25");
        }
        catch (Exception e) {
            log.error("\u5220\u9664chart\u5931\u8d25:", (Throwable)e);
            return Result.getError((String)("\u90e8\u7f72\u5931\u8d25:" + e.getMessage()));
        }
    }

    public Map<ResourcesType, String> queryStatus(String releaseName) {
        try {
            Tiller.GetReleaseStatusRequest.Builder builder = Tiller.GetReleaseStatusRequest.newBuilder();
            releaseName = releaseName.replace("_", "-");
            builder.setName(releaseName);
            ReleaseManager chartManager = new ReleaseManager(this.tiller);
            Future<Tiller.GetReleaseStatusResponse> status = chartManager.getStatus(builder.build());
            Tiller.GetReleaseStatusResponse getReleaseStatusResponse = status.get();
            StatusOuterClass.Status status2 = getReleaseStatusResponse.getInfo().getStatus();
            Map<ResourcesType, String> readResources = null;
            if (StatusOuterClass.Status.Code.DEPLOYED == status2.getCode()) {
                readResources = ResourcesType.readResources(status2.getResources());
            } else {
                readResources = new HashMap<ResourcesType, String>();
                for (ResourcesType resourcesType : ResourcesType.values()) {
                    readResources.put(resourcesType, status2.getCode().name());
                }
            }
            return readResources;
        }
        catch (Exception e) {
            if (!e.getMessage().contains("not found")) {
                log.error("\u83b7\u53d6\u8d44\u6e90\u72b6\u6001\u5f02\u5e38", (Throwable)e);
            }
            return new HashMap<ResourcesType, String>();
        }
    }

    public Result installUriChart(String name, String namespace, String uriStr, Object ... keyValues) {
        ChartOuterClass.Chart.Builder chartBuilder = null;
        try {
            URI uri = URI.create(uriStr);
            URL url = uri.toURL();
            URLConnection connection = url.openConnection();
            Validate.notNull((Object)connection);
            connection.addRequestProperty("Accept-Encoding", "gzip");
            connection.connect();
            Validate.isTrue((boolean)"application/x-tar".equals(connection.getContentType()), (String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff0c\u9700\u8981.tgz\u7ed3\u5c3e\u7684\u538b\u7f29\u5305", (Object[])new Object[0]);
            chartBuilder = this.urlLoader.load(url);
        }
        catch (Throwable e) {
            log.error("\u5730\u5740\u3010" + uriStr + "\u3011\u4e0d\u80fd\u8f6c\u4e3aChart\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u7684\u5730\u5740:", e);
            return Result.getError((String)("\u5730\u5740\u3010" + uriStr + "\u3011\u4e0d\u80fd\u8f6c\u4e3aChart\uff0c\u8bf7\u68c0\u67e5\u6b63\u786e\u7684\u5730\u5740:" + e.getMessage()));
        }
        return this.installChart(name, namespace, chartBuilder, keyValues);
    }
}

