/*
 * Decompiled with CFR 0.152.
 */
package common.kubernetes.constant;

import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public enum ResourcesType implements IEnumCombobox
{
    Service("\u7f51\u7edc", "Service", new String[]{"NAME", "TYPE", "CLUSTER-IP", "EXTERNAL-IP", "PORT(S)", "AGE"}),
    Deployment("\u90e8\u7f72", "Deployment", new String[]{"NAME", "DESIRED", "CURRENT", "UP-TO-DATE", "AVAILABLE", "AGE"}),
    Pod("Pod", "Pod", new String[]{"NAME", "READY", "STATUS", "RESTARTS", "AGE"}),
    Unknown("\u4e0d\u652f\u6301\u7684\u7c7b\u578b", "Unknown", new String[0]);

    private final String desc;
    private final String desc_en;
    private final String[] colNames;

    private ResourcesType(String desc, String desc_en, String[] colNames) {
        this.desc = desc;
        this.desc_en = desc_en;
        this.colNames = colNames;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public String[] getColNames() {
        return this.colNames;
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.desc_en;
    }

    public String getColValue(String valueStr, String colName) {
        int indexOf = ArrayUtils.indexOf((Object[])this.colNames, (Object)colName);
        if (StringUtil.isNull((Object)valueStr) || indexOf < 0) {
            return "";
        }
        String[] mens = valueStr.replaceAll("\\s+", "|").split("\\|");
        return mens[indexOf];
    }

    public static Map<ResourcesType, String> readResources(String resourcesStr) {
        String[] split = resourcesStr.split("\n");
        ResourcesType curType = Unknown;
        HashMap<ResourcesType, String> retmap = new HashMap<ResourcesType, String>();
        int no = 0;
        block0: for (String ele : split) {
            if (StringUtil.isNull((Object)ele)) continue;
            if (curType == Unknown) {
                for (ResourcesType rst : ResourcesType.values()) {
                    if (!ele.contains("/" + rst.name())) continue;
                    curType = rst;
                    continue block0;
                }
                continue;
            }
            if (curType == Unknown) continue;
            if (no == 1) {
                retmap.put(curType, ele);
                no = 0;
                curType = Unknown;
                continue;
            }
            if (ele.startsWith("NAME ")) {
                ++no;
                continue;
            }
            if (!StringUtil.isNotNull((Object)ele)) continue;
            retmap.put(curType, ele);
            no = 0;
            curType = Unknown;
        }
        return retmap;
    }

    public static ResourcesType find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (ResourcesType ele : ResourcesType.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return Unknown;
    }
}

