package common.kubernetes.apiserver;

public enum K8sInfo {
	image("镜像", "/spec/template/spec/containers/image", new K8sKind[] { K8sKind.ReplicationController }),
	
	Labels("镜像", "/spec/template/spec/containers/image", new K8sKind[] { K8sKind.ReplicationController }),
	

	containerPort("容器端口", "/spec/template/spec/containers/ports/containerPort",
			new K8sKind[] { K8sKind.ReplicationController });

	private final String desc;
	private final String path;
	private final K8sKind[] groups;

	private K8sInfo(String desc, String path, K8sKind[] groups) {
		this.desc = desc;
		this.path = path;
		this.groups = groups;
	}

	public String getDesc() {
		return desc;
	}

	public String getPath() {
		return path;
	}

	public K8sKind[] getGroups() {
		return groups;
	}
}
