/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions.regexp;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.functions.regexp.AbstractRegExpWrapper;
import org.josql.functions.regexp.RegExp;

public class GNURegExpWrapper
extends AbstractRegExpWrapper
implements RegExp {
    public static final String SUPPORTED_VERSION = "1.1.4";
    private final String reClassName = "gnu.regexp.RE";
    private final String isMatchMethName = "isMatch";
    private Map patterns = new HashMap();
    private Constructor cons = null;
    private Method isMatchMeth = null;

    @Override
    public String getSupportedVersion() {
        return SUPPORTED_VERSION;
    }

    @Override
    public boolean isAvailable(Query q) {
        try {
            q.loadClass(this.reClassName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean match(String pattern, String val) throws QueryExecutionException {
        try {
            Object[] args;
            Object o = this.patterns.get(pattern);
            if (o == null) {
                args = new Object[]{pattern};
                o = this.cons.newInstance(args);
                this.patterns.put(pattern, o);
            }
            args = new Object[]{val};
            return (Boolean)this.isMatchMeth.invoke(o, args);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to match value: " + val + " against pattern: " + pattern, e);
        }
    }

    @Override
    public void init(Query q) throws QueryExecutionException {
        try {
            Class reClass = q.loadClass("gnu.regexp.RE");
            Class[] argTypes = new Class[]{Object.class};
            this.cons = reClass.getConstructor(argTypes);
            this.isMatchMeth = reClass.getMethod(this.isMatchMethName, argTypes);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init", e);
        }
    }
}

