/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.josql.QueryExecutionException;
import org.josql.functions.AbstractFunctionHandler;

public class ConversionFunctions
extends AbstractFunctionHandler {
    public static final String HANDLER_ID = "_internal_conversion";
    public static final String MINUTE = "mi";
    public static final String DAY = "d";
    public static final String YEAR = "y";
    public static final String SECOND = "s";
    public static final String HOUR = "h";
    public static final String MONTH = "m";
    public static final String WEEK = "w";
    public static String DEFAULT_DATE_FORMAT_SPEC = "dd/MMM/yyyy";
    public static String DEFAULT_DATE_FORMAT_SPEC_2 = "dd-MMM-yyyy";
    public static String DEFAULT_DATE_FORMAT_SPEC_3 = "dd MMM yyyy";
    private Map sdfs = new HashMap();
    private Calendar cal = Calendar.getInstance();

    public ConversionFunctions() {
        this.sdfs.put(DEFAULT_DATE_FORMAT_SPEC, new SimpleDateFormat(DEFAULT_DATE_FORMAT_SPEC));
        this.sdfs.put(DEFAULT_DATE_FORMAT_SPEC_2, new SimpleDateFormat(DEFAULT_DATE_FORMAT_SPEC_2));
        this.sdfs.put(DEFAULT_DATE_FORMAT_SPEC_3, new SimpleDateFormat(DEFAULT_DATE_FORMAT_SPEC_3));
    }

    public int timeField(Object d, String type) throws QueryExecutionException {
        if (!(d instanceof Date) && !(d instanceof Long)) {
            throw new QueryExecutionException("Value passed in is of type: " + d.getClass().getName() + " only: " + Long.class.getName() + " or: " + Date.class.getName() + " are supported.");
        }
        Date date = null;
        if (d instanceof Long) {
            date = new Date((Long)d);
        }
        if (d instanceof Date) {
            date = (Date)d;
        }
        this.cal.setTime(date);
        type = type.toLowerCase();
        if (type.equals(SECOND)) {
            return this.cal.get(13);
        }
        if (type.equals(MINUTE)) {
            return this.cal.get(12);
        }
        if (type.equals(HOUR)) {
            return this.cal.get(11);
        }
        if (type.equals(DAY)) {
            return this.cal.get(5);
        }
        if (type.equals(WEEK)) {
            return this.cal.get(3);
        }
        if (type.equals(MONTH)) {
            return this.cal.get(2);
        }
        if (type.equals(YEAR)) {
            return this.cal.get(1);
        }
        return -1;
    }

    public Date addTime(Date d, Double amount, String type) {
        int a = amount.intValue();
        long v = d.getTime();
        if (type.equals(SECOND)) {
            return new Date(v += (long)a * 1000L);
        }
        if (type.equals(MINUTE)) {
            return new Date(v += (long)a * 60000L);
        }
        if (type.equals(HOUR)) {
            return new Date(v += (long)a * 3600000L);
        }
        if (type.equals(DAY)) {
            return new Date(v += (long)a * 24L * 3600000L);
        }
        if (type.equals(WEEK)) {
            return new Date(v += (long)a * 7L * 24L * 3600000L);
        }
        if (type.equals(MONTH)) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d);
            gc.add(2, a);
            return gc.getTime();
        }
        if (type.equals(YEAR)) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(d);
            gc.add(1, a);
            return gc.getTime();
        }
        return d;
    }

    public Date toDate(Object value) throws QueryExecutionException {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            return this.toDate((String)value, null);
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        throw new QueryExecutionException("Type: " + value.getClass().getName() + " is not supported.");
    }

    public Date to_date(Object value) throws QueryExecutionException {
        return this.toDate(value);
    }

    public Date to_date(String value, String spec) throws QueryExecutionException {
        return this.toDate(value, spec);
    }

    public Date toDate(String value, String spec) throws QueryExecutionException {
        SimpleDateFormat df;
        if (spec == null) {
            spec = DEFAULT_DATE_FORMAT_SPEC;
        }
        if ((df = (SimpleDateFormat)this.sdfs.get(spec)) == null) {
            df = new SimpleDateFormat(spec);
            this.sdfs.put(spec, df);
        }
        try {
            return df.parse(value);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to parse date value: " + value + " using spec: " + spec, e);
        }
    }

    public Long toMillis(Date d) {
        return new Long(d.getTime());
    }

    public Long toDateMillis(String value, String spec) throws QueryExecutionException {
        SimpleDateFormat df;
        if (spec == null) {
            spec = DEFAULT_DATE_FORMAT_SPEC;
        }
        if ((df = (SimpleDateFormat)this.sdfs.get(spec)) == null) {
            df = new SimpleDateFormat(spec);
            this.sdfs.put(spec, df);
        }
        try {
            Date d = df.parse(value);
            return new Long(d.getTime());
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to parse date value: " + value + " using spec: " + spec, e);
        }
    }

    public String upper(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString().toUpperCase();
    }

    public String lower(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString().toLowerCase();
    }

    public String to_string(Object o) {
        return this.toString(o);
    }

    public String toString(Object o) {
        return o + "";
    }

    public Number to_number(Object o) {
        return this.toNumber(o);
    }

    public Number toNumber(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            try {
                return new Double((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (o instanceof Date) {
            return new Double(((Date)o).getTime());
        }
        if (!(o instanceof Number)) {
            return null;
        }
        return (Number)o;
    }
}

