/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import com.gentlyweb.utils.Getter;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.ValueExpression;
import org.josql.internal.Utilities;

public class SaveValue
extends ValueExpression {
    private String name = null;
    private String acc = null;
    private Getter get = null;

    @Override
    public Class getExpectedReturnType(Query q) throws QueryParseException {
        Object sv = q.getSaveValue(this.name);
        if (sv != null) {
            if (this.acc != null) {
                try {
                    this.get = new Getter(this.acc, sv.getClass());
                }
                catch (Exception e) {
                    throw new QueryParseException("Unable to create dynamic getter from instance of type: " + sv.getClass().getName() + " for save value: " + this.name + " using accessor: " + this.acc, e);
                }
                return this.get.getType();
            }
            return sv.getClass();
        }
        return Object.class;
    }

    @Override
    public void init(Query q) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object getValue(Object o, Query q) throws QueryExecutionException {
        Object v = q.getSaveValue(this.name);
        if (v == null) {
            return v;
        }
        if (this.acc != null && this.get == null) {
            try {
                this.get = new Getter(this.acc, v.getClass());
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to create dynamic getter from instance of type: " + v.getClass().getName() + " for save value: " + this.name + " using accessor: " + this.acc, e);
            }
        }
        if (this.get != null) {
            try {
                v = this.get.getValue(v);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from instance of type: " + v.getClass().getName() + " for save value: " + this.name + " using accessor: " + this.acc, e);
            }
        }
        return v;
    }

    @Override
    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        if ((o = this.getValue(o, q)) == null) {
            return false;
        }
        if (Utilities.isNumber(o)) {
            return Utilities.getDouble(o) > 0.0;
        }
        return true;
    }

    public String getAccessor() {
        return this.acc;
    }

    public void setAccessor(String acc) {
        this.acc = acc;
    }

    @Override
    public Object evaluate(Object o, Query q) throws QueryExecutionException {
        return this.getValue(o, q);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("@");
        buf.append(this.name);
        if (this.acc != null) {
            buf.append(".");
            buf.append(this.acc);
        }
        if (this.isBracketed()) {
            buf.insert(0, "(");
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public boolean hasFixedResult(Query q) {
        return false;
    }
}

