/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import java.util.ArrayList;
import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.Expression;
import org.josql.expressions.ValueExpression;

public class ExpressionList
extends ValueExpression {
    private List expressions = null;

    @Override
    public Class getExpectedReturnType(Query q) {
        return List.class;
    }

    @Override
    public void init(Query q) throws QueryParseException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression exp = (Expression)this.expressions.get(i);
            exp.init(q);
        }
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void addExpression(Expression expr) {
        if (this.expressions == null) {
            this.expressions = new ArrayList();
        }
        this.expressions.add(expr);
    }

    public void setExpressions(List exprs) {
        this.expressions = exprs;
    }

    @Override
    public Object getValue(Object o, Query q) throws QueryExecutionException {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression exp = (Expression)this.expressions.get(i);
            ret.add(exp.getValue(o, q));
        }
        return ret;
    }

    @Override
    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression exp = (Expression)this.expressions.get(i);
            if (exp.getValue(o, q) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object evaluate(Object o, Query q) throws QueryExecutionException {
        return this.getValue(o, q);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < this.expressions.size(); ++i) {
            buf.append(this.expressions.get(i));
            if (i >= this.expressions.size() - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean hasFixedResult(Query q) {
        if (this.expressions.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.expressions.size(); ++i) {
            Expression exp = (Expression)this.expressions.get(i);
            if (exp.hasFixedResult(q)) continue;
            return false;
        }
        return true;
    }
}

