/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import com.gentlyweb.utils.Getter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.ValueExpression;
import org.josql.internal.Utilities;

public class BindVariable
extends ValueExpression {
    public static final String SPECIAL_NAME_PREFIX = "_";
    private static Map SPECIAL_VAR_NAMES = new HashMap();
    private String name = null;
    private Object val = null;
    private boolean anon = false;
    private String acc = null;
    private Getter get = null;
    private boolean groupByVar = false;
    private int groupByInd = 0;

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BindVariable)) {
            return false;
        }
        BindVariable b = (BindVariable)o;
        return b.getName() != null && this.name != null && b.getName().equals(this.name) && this.acc != null && b.getAccessor() != null && b.getAccessor().equals(this.acc);
    }

    public String getAccessor() {
        return this.acc;
    }

    public void setAccessor(String a) {
        this.acc = a;
    }

    @Override
    public Class getExpectedReturnType(Query q) throws QueryParseException {
        if (this.get != null) {
            return this.get.getType();
        }
        if (this.val != null) {
            return this.val.getClass();
        }
        return q.getVariableClass(this.name);
    }

    private void initForGroupByName(String n, Query q) throws QueryParseException {
        List grpBys = q.getGroupByColumns();
        if (grpBys == null) {
            throw new QueryParseException("Use of special group by object bind variable: " + this.name + " is not valid when there are no GROUP BY clauses defined.");
        }
        String rest = "";
        if (n.startsWith(Query.GRPBY_OBJ_VAR_NAME)) {
            rest = n.substring(Query.GRPBY_OBJ_VAR_NAME.length());
        }
        if (n.startsWith(Query.GRPBY_OBJ_VAR_NAME_SYNONYM)) {
            rest = n.substring(Query.GRPBY_OBJ_VAR_NAME_SYNONYM.length());
        }
        int grpbyind = 1;
        if (rest.length() > 0) {
            try {
                grpbyind = Integer.parseInt(rest);
            }
            catch (Exception e) {
                throw new QueryParseException("Special bind variable name: " + this.name + " is not valid, expected an integer number at end of name for indexing into GROUP BYs.");
            }
            if (grpbyind < 1) {
                throw new QueryParseException("Special bind variable name: " + this.name + " is not valid, integer to index GROUP BYs must be a minimum of 1.");
            }
            if (grpbyind > grpBys.size()) {
                throw new QueryParseException("Special bind variable name: " + this.name + " is not valid, integer references GROUP BY: " + grpbyind + " however there are only: " + grpBys.size() + " GROUP BYs defined.");
            }
        }
        this.groupByVar = true;
        this.groupByInd = grpbyind;
    }

    @Override
    public void init(Query q) throws QueryParseException {
        Class c;
        String n;
        if (this.anon) {
            this.name = q.getAnonymousBindVariableName();
        }
        if ((n = this.name.toLowerCase()).startsWith(Query.GRPBY_OBJ_VAR_NAME) || n.startsWith(Query.GRPBY_OBJ_VAR_NAME_SYNONYM)) {
            this.initForGroupByName(n, q);
        } else if (n.startsWith(SPECIAL_NAME_PREFIX) && !SPECIAL_VAR_NAMES.containsKey(n)) {
            throw new QueryParseException("Bind variable name: " + this.name + " is not valid, bind variable names starting with: " + SPECIAL_NAME_PREFIX + " are reserved, and must be one of: " + SPECIAL_VAR_NAMES.keySet());
        }
        this.val = q.getVariable(this.name);
        if (this.val != null && this.acc != null) {
            this.initGetter(this.val);
            try {
                this.val = this.get.getValue(this.val);
            }
            catch (Exception e) {
                throw new QueryParseException("Unable to get value from accessor: " + this.acc + " and class: " + this.val.getClass().getName() + " from bind variable: " + this.name, e);
            }
        }
        if (this.acc != null && this.get == null && !(c = q.getVariableClass(this.name)).isInstance(new Object())) {
            this.initGetter(c);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isAnonymous() {
        return this.anon;
    }

    public void setAnonymous(boolean v) {
        this.anon = v;
    }

    public void setName(String name) {
        this.name = name;
    }

    private void initGetter(Object o) {
        Class<?> c = o.getClass();
        this.initGetter(c);
    }

    private void initGetter(Class c) {
        this.get = new Getter(this.acc, c);
    }

    @Override
    public Object getValue(Object o, Query q) throws QueryExecutionException {
        o = this.groupByVar ? q.getGroupByVariable(this.groupByInd) : q.getVariable(this.name);
        if (this.acc != null && this.get == null && o != null) {
            this.initGetter(o);
        }
        if (this.get != null) {
            try {
                o = this.get.getValue(o);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value for accessor: " + this.acc + ", class: " + this.get.getBaseClass().getName() + " from bind variable: " + this.name, e);
            }
        }
        return o;
    }

    @Override
    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        if ((o = this.getValue(o, q)) == null) {
            return false;
        }
        if (Utilities.isNumber(o)) {
            return Utilities.getDouble(o) > 0.0;
        }
        return true;
    }

    @Override
    public Object evaluate(Object o, Query q) throws QueryExecutionException {
        return this.getValue(o, q);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.anon) {
            buf.append("?");
        } else {
            buf.append(":");
            buf.append(this.name);
        }
        if (this.acc != null) {
            buf.append(".");
            buf.append(this.acc);
        }
        if (this.isBracketed()) {
            buf.insert(0, "(");
            buf.append(")");
        }
        return buf.toString();
    }

    @Override
    public boolean hasFixedResult(Query q) {
        return false;
    }

    static {
        SPECIAL_VAR_NAMES.put(Query.QUERY_BIND_VAR_NAME, "");
        SPECIAL_VAR_NAMES.put(Query.CURR_OBJ_VAR_NAME, "");
        SPECIAL_VAR_NAMES.put(Query.ALL_OBJS_VAR_NAME, "");
        SPECIAL_VAR_NAMES.put(Query.GRPBY_OBJ_VAR_NAME, "");
        SPECIAL_VAR_NAMES.put(Query.GRPBY_OBJ_VAR_NAME_SYNONYM, "");
        SPECIAL_VAR_NAMES.put(Query.PARENT_BIND_VAR_NAME, "");
    }
}

