/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.Expression;

public abstract class BinaryExpression
extends Expression {
    protected Expression left = null;
    protected Expression right = null;

    @Override
    public boolean hasFixedResult(Query q) {
        boolean fr = true;
        if (this.right != null) {
            fr = this.right.hasFixedResult(q);
        }
        return this.left.hasFixedResult(q) && fr;
    }

    @Override
    public Class getExpectedReturnType(Query q) {
        return Boolean.class;
    }

    @Override
    public void init(Query q) throws QueryParseException {
        this.left.init(q);
        if (this.right != null) {
            this.right.init(q);
        }
    }

    @Override
    public Object getValue(Object o, Query q) throws QueryExecutionException {
        return this.isTrue(o, q);
    }

    public Expression getRight() {
        return this.right;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression exp) {
        this.left = exp;
    }

    public void setRight(Expression exp) {
        this.right = exp;
    }
}

