package org.josql.internal;

import java.util.*;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

import java.util.StringTokenizer;

import com.gentlyweb.utils.Getter;


public class Setter
{

    private Getter getter = null;
    private Object setter = null;
    private Class clazz = null;

    /**
     * @param ref The reference for the setter.
     * @param clazz The Class to get the field from.
     */
    public Setter (String  ref,
		   Class   clazz,
		   Class[] parmTypes)
	           throws  IllegalArgumentException,
	                   NoSuchMethodException
    {

	this.clazz = clazz;

	StringTokenizer t = new StringTokenizer (ref,
						 ".");

	StringBuffer getRef = new StringBuffer ();

	if (t.countTokens () > 1)
	{

	    // Get everything up to the last part.
	    while (t.hasMoreTokens ())
	    {
		
		getRef.append (t.nextToken ());

		if (t.countTokens () > 1)
		{

		    getRef.append ('.');

		}

		if (t.countTokens () == 1)
		{

		    // Now get the Getter.
		    this.getter = new Getter (getRef.toString (),
					      clazz);

		    // Get the return type from the getter.
		    clazz = this.getter.getType ();

		    break;

		}

	    }

	}

	// Now for the final part this is the setter.
	String set = t.nextToken ();

	// Get the Fields.
	Field[] fields = clazz.getFields ();
	
	Field f = null;
	
	// See if the token matches...
	for (int i = 0; i < fields.length; i++)
	{
	    
	    if (fields[i].getName ().equals (set))
	    {
		
		// Found it...
		f = fields[i];
		
		this.setter = f;
		
		return;
		
	    }
	    
	}
	
	// If we are here then it's not a public field.
	
	// Now convert it to a method name and use the
	// JavaBeans convention...
	
	// Now get the method...
	StringBuffer name = new StringBuffer (set);

	name.setCharAt (0,
			Character.toUpperCase (name.charAt (0)));

	name.insert (0,
		     "set");

	String nName = name.toString ();

	List meths = new ArrayList ();

	Utilities.getMethods (clazz,
			      nName,
			      Modifier.PUBLIC,
			      meths);

	TreeMap sm = new TreeMap ();

	// Now compare the parm types.
	for (int i = 0; i < meths.size (); i++)
	{

	    Method m = (Method) meths.get (i);

	    Class[] mpts = m.getParameterTypes ();

	    int score = Utilities.matchMethodArgs (mpts,
						   parmTypes);

	    if (score > 0)
	    {

		sm.put (Integer.valueOf (score),
			m);

	    }

	}

	// Get the last key
	if (sm.size () > 0)
	{

	    this.setter = (Method) sm.get (sm.lastKey ());

	}

	if (this.setter == null)
	{

	    meths = new ArrayList ();

	    Utilities.getMethods (clazz,
				  set,
				  Modifier.PUBLIC,
				  meths);

	    sm = new TreeMap ();

	    // Now compare the parm types.
	    for (int i = 0; i < meths.size (); i++)
	    {

		Method m = (Method) meths.get (i);

		Class[] mpts = m.getParameterTypes ();
		
		int score = Utilities.matchMethodArgs (mpts,
						       parmTypes);

		if (score > 0)
		{

		    sm.put (Integer.valueOf (score),
			    m);

		}

	    }

	    // Get the last key
	    if (sm.size () > 0)
	    {

		this.setter = (Method) sm.get (sm.lastKey ());

	    }

	}

	if (this.setter == null)
	{

	    throw new IllegalArgumentException ("Unable to find required method: " +
						nName + 
						" or: " + 
						set +
						" in class: " +
						clazz.getName () +
						" taking parms: " +
						Arrays.toString (parmTypes));

	}
	
    }

    public Class getBaseClass ()
    {

	return this.clazz;

    }

    public void setValue (Object target,
			  Object value)
                          throws IllegalAccessException,
	                         InvocationTargetException,
                                 IllegalArgumentException
    {

	Object[] vals = {value};
	
	this.setValue (target,
		       vals);

    }

    public void setValue (Object   target,
			  Object[] values)
                          throws   IllegalAccessException,
	                           InvocationTargetException,
                                   IllegalArgumentException
    {

	// Get the object to set on from the getter.
	if (this.getter != null)
	{

	    target = this.getter.getValue (target);

	}

	// Now call our accessor on the obj and set the value.
	if (this.setter instanceof Field)
	{

	    Field f = (Field) this.setter;

	    f.set (target,
		   values[0]);

	    return;

	}
	
	if (this.setter instanceof Method)
	{

	    Method m = (Method) this.setter;

	    m.invoke (target,
		      Utilities.convertArgs (values,
					     m.getParameterTypes ()));

	}

    }

    /**
     * Get the class of the type of object we expect in the {@link #setValue(Object,Object)}
     * method.
     *
     * @return The class.
     */
    public Class getType ()
    {

	// See what type the accessor is...
	if (this.setter instanceof Method)
	{
		
	    Method m = (Method) this.setter;
		
	    Class[] parms = m.getParameterTypes ();

	    return parms[0];

	}
	    
	if (this.setter instanceof Field)
	{
		
	    // It's a field...so...
	    Field f = (Field) this.setter;

	    return f.getType ();

	}

	return null;

    }

}
