/*
 * Copyright 2004-2007 Gary Bentley 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may 
 * not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 *    http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
package org.josql.expressions;

import org.josql.Query;
import org.josql.QueryExecutionException;


public class AndOrExpression extends BinaryExpression
{

    private boolean and = false;

    public boolean isAnd ()
    {

	return this.and;

    }

    public void setAnd (boolean v)
    {

	this.and = v;

    }

    
    public boolean isTrue (Object o,
			   Query  q)
	                   throws QueryExecutionException
    {

	// Execute left first.
	boolean l = this.left.isTrue (o,
				      q);

	// See what our predicate is...
	if (this.and)
	{

            if (!l)
            {

               return false;

            }

	    boolean r = this.right.isTrue (o,
					   q);

	    return l && r;

	}

	if (l)
	{

	    return true;

	}

	boolean r = this.right.isTrue (o,
				       q);
	
	return r;

    }

    /**
     * Return a string version of this expression.
     * Note: any formatting of the statement (such as line breaks) will be removed.
     *
     * @return A string version of the expression.  
     */
    public String toString ()
    {

	String pred = " OR ";
	
	if (this.and)
	{

	    pred = " AND ";

	}

	if (this.isBracketed ())
	{

	    return "(" + this.left.toString () + pred + this.right.toString () + ")";

	}

	return this.left.toString () + pred + this.right.toString ();

    }

}
