/*
 * Copyright 2006 - Gary Bentley
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.gentlyweb.utils;

public class NumberUtils
{

    
    public static double toPrecision (double v,
				      int    digits)
    {

	if (v == 0)
	{

	    return v;

	}

	double mult = Math.pow (10, 
				digits);

	double r = Math.floor (v);

	return r + ((Math.round ((v - r) * mult)) / mult);

    }

    /**
     * Given an int value treat it as a number of days and return 
     * the number of milliseconds for that number of days.
     *
     * @param days Number of days.
     * @return A long giving the number of milliseconds.
     */
    public static long getDaysAsMillis (int days)
    {

	return (long) days * 86400000;

    }

    /**
     * Convert a number of milliseconds into seconds, we format to 2 decimal
     * places, i.e. we return a String of the form a.xy.
     *
     * @param millis The milliseconds to format.
     * @return A String formatted as a.xy.
     */
    public static String getMillisAsFormattedSeconds (long millis)
    {

	long secs = millis / 1000;
	
	long tenths = (millis - (secs * 1000)) / 100;

	long hundredths = (millis - (secs * 1000) - (tenths * 100)) / 10;

	return secs + "." + tenths + hundredths;

    }

}
