/*
 * Copyright 2006 - Gary Bentley
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.gentlyweb.utils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;

import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.StringTokenizer;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Attribute;

public class GeneralComparator implements Comparator, Serializable// ,
// JDOMXmlOutputter
{

	public class XMLConstants {

		public static final String root = "comparator";
		public static final String clazz = "class";
		public static final String field = "field";
		public static final String id = "id";
		public static final String type = "type";

	}

	public int count = 0;

	/**
	 * Use to indicate that a field should be sorted in ascending order.
	 */
	public static final String ASC = "ASC";

	/**
	 * Use to indicate that a field should be sorted in descending order.
	 */
	public static final String DESC = "DESC";

	private List fields = new ArrayList();

	private Class clazz = null;

	
	/*
	 * public GeneralComparator (Element root) throws JDOMException, ChainException,
	 * IllegalArgumentException {
	 * 
	 * JDOMUtils.checkName (root, GeneralComparator.XMLConstants.root, true);
	 * 
	 * // Get the class. String clazz = JDOMUtils.getAttributeValue (root,
	 * GeneralComparator.XMLConstants.clazz);
	 * 
	 * try {
	 * 
	 * this.clazz = Class.forName (clazz);
	 * 
	 * } catch (Exception e) {
	 * 
	 * throw new ChainException ("Unable to load class: " + clazz, e);
	 * 
	 * }
	 * 
	 * // Get all the fields, there should be at least 1. List fEls =
	 * JDOMUtils.getChildElements (root, GeneralComparator.XMLConstants.field,
	 * true);
	 * 
	 * for (int i = 0; i < fEls.size (); i++) {
	 * 
	 * Element e = (Element) fEls.get (i);
	 * 
	 * // Get the id attribute. String id = JDOMUtils.getAttributeValue (e,
	 * GeneralComparator.XMLConstants.id);
	 * 
	 * // Get the type attribute. String type = JDOMUtils.getAttributeValue (e,
	 * GeneralComparator.XMLConstants.type);
	 * 
	 * if ((!type.equals (GeneralComparator.ASC)) && (!type.equals
	 * (GeneralComparator.DESC)) ) {
	 * 
	 * Attribute attr = JDOMUtils.getAttribute (e,
	 * GeneralComparator.XMLConstants.type, true);
	 * 
	 * throw new JDOMException ("Type (path: " + JDOMUtils.getPath (attr) +
	 * ") must be either: " + GeneralComparator.ASC + " or: " +
	 * GeneralComparator.DESC);
	 * 
	 * }
	 * 
	 * // Add the field. this.addField (id, type);
	 * 
	 * }
	 * 
	 * }
	 */

	public GeneralComparator(Class c) {

		this.clazz = c;

	}

	public Class getCompareClass() {

		return this.clazz;

	}

	public void addField(Getter field, String type) throws IllegalArgumentException {

		// Get the class that the getter relates to, they MUST be the same class AND the
		// same object... classes loaded via other classloaders are not compatible.
		if (field.getBaseClass().hashCode() != this.clazz.hashCode()) {

			throw new IllegalArgumentException(
					"Class in Getter is: " + field.getBaseClass().getName() + " with hashCode: "
							+ field.getBaseClass().hashCode() + " which is incompatible with comparator class: "
							+ this.clazz.getName() + " with hashCode: " + this.clazz.hashCode());

		}

		if (this.fields.size() == 0) {

			this.fields.add(0, new SortField(field, type, this.clazz));

			return;

		}

		this.fields.add(this.fields.size(), new SortField(field, type, this.clazz));

	}


	public void addFieldAtIndex(String field, String type, int index) throws IllegalArgumentException {

		if (index < 0) {

			this.fields.add(0, new SortField(field, type, this.clazz));

			return;

		}

		if (index > (this.fields.size() - 1)) {

			this.fields.add(new SortField(field, type, this.clazz));

			return;

		}

		this.fields.add(index, new SortField(field, type, this.clazz));

	}

	/**
	 * Add a new field in BEFORE the named field, if we don't have the named field
	 * then we just call {@link #addField(String,String)} which will add the field
	 * in after all the others.
	 *
	 * @param field The field to add.
	 * @param type  Sort either ascending or descending, should be either
	 *              GeneralComparator.ASC or GeneralComparator.DESC.
	 * @param ref   The reference field.
	 * @throws IllegalArgumentException If we can't find the field in the
	 *                                  class/class chain passed into the
	 *                                  constructor.
	 */
	public void addFieldBefore(String field, String type, String ref) throws IllegalArgumentException {

		// Get the field index...
		int fi = this.getFieldIndex(ref);

		if (fi != -1) {

			this.addFieldAtIndex(field, type, --fi);

		} else {

			this.addField(field, type);

		}

	}

	/**
	 * Add a new field in AFTER the named field, if we don't have the named field
	 * then we just call {@link #addField(String,String)} which will add the field
	 * in after all the others.
	 *
	 * @param field The field to add.
	 * @param type  Sort either ascending or descending, should be either
	 *              GeneralComparator.ASC or GeneralComparator.DESC.
	 * @param ref   The reference field.
	 * @throws IllegalArgumentException If we can't find the field in the
	 *                                  class/class chain passed into the
	 *                                  constructor.
	 */
	public void addFieldAfter(String field, String type, String ref) throws IllegalArgumentException {

		// Get the field index...
		int fi = this.getFieldIndex(ref);

		if (fi != -1) {

			this.addFieldAtIndex(field, type, ++fi);

		} else {

			this.addField(field, type);

		}

	}

	/**
	 * Remove a field that we sort on. If we don't have the field then we do
	 * nothing.
	 *
	 * @param field The field to remove.
	 */
	public void removeField(String field) {

		SortField f = this.getField(field);

		if (f != null) {

			this.fields.remove(f);

		}

	}

	/**
	 * Add a field that we sort on, if you readd the same field then the type is
	 * just updated. The order in which you add the fields provides the order in
	 * which the objects are sorted.
	 *
	 * @param field The field to sort on.
	 * @param type  The type either GeneralComparator.ASC or GeneralComparator.DESC.
	 * @throws IllegalArgumentException If we can't find the field in the
	 *                                  class/class chain passed into the
	 *                                  constructor.
	 */
	public void addField(String field, String type) throws IllegalArgumentException {

		// Find the field...
		SortField f = this.getField(field);

		if (f != null) {

			f.type = type;
			return;

		}

		this.addFieldAtIndex(field, type, (this.fields.size() + 1));

	}

	/**
	 * Get the index of this field.
	 *
	 * @param field The field to look for.
	 * @return The index (0 or greater) or -1 if we don't have the field.
	 */
	private int getFieldIndex(String field) {

		for (int i = 0; i < this.fields.size(); i++) {

			SortField f = (SortField) this.fields.get(i);

			if (f.field.equals(field)) {

				return i;

			}

		}

		return -1;

	}

	/**
	 * Get a field given a field name.
	 *
	 * @param field The name of the field.
	 * @return The SortField object or null if we don't have it.
	 */
	private SortField getField(String field) {

		for (int i = 0; i < this.fields.size(); i++) {

			SortField f = (SortField) this.fields.get(i);

			if (f.field.equals(field)) {

				return f;

			}

		}

		return null;

	}


	public int compare(Object obj1, Object obj2) {

		this.count++;

		if ((obj1 == null) || (obj2 == null)) {

			return 0;

		}

		if ((!this.clazz.isAssignableFrom(obj1.getClass())) || (!this.clazz.isAssignableFrom(obj2.getClass()))) {

			throw new IllegalArgumentException("Expected objects of type: " + this.clazz.getName() + ", got: "
					+ obj1.getClass().getName() + ", and: " + obj2.getClass().getName());

		}

		try {

			for (int i = 0; i < this.fields.size(); i++) {

				SortField f = (SortField) this.fields.get(i);

				Object val1 = f.getValue(obj1);
				Object val2 = f.getValue(obj2);

				// Can't compare what's not there, return 0.
				if ((val1 == null) || (val2 == null)) {

					return 0;

				}

				int v = 0;

				if (val1 instanceof Comparable) {

					// We can use a simple compareTo.
					Comparable comp = (Comparable) val1;

					v = comp.compareTo(val2);

				} else {

					v = val1.toString().compareTo(val2.toString());

				}

				if (v != 0) {

					if (f.getType().equals(GeneralComparator.DESC)) {

						return -1 * v;

					}

					// This is an ascending sort...
					return v;

				}

				// They are equal, so need to go to the next field...
				continue;

			}

		} catch (IllegalAccessException e) {

		} catch (InvocationTargetException e) {

		}

		return 0;

	}


	public boolean equals(Object obj) {

		GeneralComparator gc = (GeneralComparator) obj;

		List oFields = gc.getFields();

		if (oFields.size() != this.fields.size()) {

			return false;

		}

		for (int i = 0; i < this.fields.size(); i++) {

			SortField f = (SortField) this.fields.get(i);

			SortField of = (SortField) oFields.get(i);

			if (f.compareTo(of) != 0) {

				return false;

			}

		}

		return true;

	}

	/**
	 * Return a List of GeneralComparator.SortField objects, this is used in the
	 * {@link #equals(Object)} method.
	 *
	 * @return A List of GeneralComparator.SortField objects.
	 */
	protected List getFields() {

		return this.fields;

	}

	public int getCount() {

		return this.count;

	}

	/**
	 * Get the comparator data as a JDOM element.
	 * 
	 * @return The built element.
	 */
	/*
	 * public Element getAsJDOMElement () {
	 * 
	 * Element root = new Element (GeneralComparator.XMLConstants.root);
	 * 
	 * // Add the class. root.setAttribute (GeneralComparator.XMLConstants.clazz,
	 * this.clazz.getName ());
	 * 
	 * // Add all the fields. for (int i = 0; i < this.fields.size (); i++) {
	 * 
	 * SortField sf = (SortField) this.fields.get (i);
	 * 
	 * Element e = new Element (GeneralComparator.XMLConstants.field);
	 * 
	 * e.setAttribute (GeneralComparator.XMLConstants.id, sf.getField ());
	 * e.setAttribute (GeneralComparator.XMLConstants.type, sf.getType ());
	 * 
	 * root.addContent (e);
	 * 
	 * }
	 * 
	 * return root;
	 * 
	 * }
	 */

	private class SortField implements Comparable {

		private String field = "";
		private String type = GeneralComparator.ASC;

		private Getter get = null;

		public SortField(String field, String type, Class c) throws IllegalArgumentException {

			this(new Getter(field, c), type, c);

			this.field = field;

		}

		public SortField(Getter field, String type, Class c) throws IllegalArgumentException {

			// Get the field or method...
			this.get = field;

			// this.field = field;

			if ((!type.equals(GeneralComparator.ASC)) && (!type.equals(GeneralComparator.DESC))) {

				throw new IllegalArgumentException(
						"Type must be either: " + GeneralComparator.ASC + " or: " + GeneralComparator.DESC);

			}

			this.type = type;

		}

		public Object getValue(Object obj) throws IllegalAccessException, InvocationTargetException {

			return this.get.getValue(obj);

		}

		protected String getField() {

			return this.field;

		}

		protected String getType() {

			return this.type;

		}

		public int compareTo(Object o) {

			SortField f = (SortField) o;

			if ((this.field.equals(f.getField())) && (this.type.equals(f.getType()))) {

				return 0;

			}

			if (this.field.equals(f.getField())) {

				return this.type.compareTo(f.getType());

			}

			return this.field.compareTo(f.getField());

		}

	}

}
