/*
 * Copyright 2006 - Gary Bentley
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.gentlyweb.utils;

import java.io.File;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import javax.activation.DataSource;


public class GZIPFileDataSource implements DataSource
{

    private File file = null;
    private String zipExtension = ".gz";

    
    public GZIPFileDataSource (File   f,
			       String zipExtension)
    {

	this.file = f;

	if (zipExtension != null)
	{

	    this.zipExtension = zipExtension.toLowerCase ();

	}

    }

    
    public String getContentType ()
    {

	String fName = this.file.getName ().toLowerCase ();

	// Strip off any gz file extension...
	if (fName.indexOf (this.zipExtension) != -1)
	{
	    
	    fName = fName.substring (0,
				     fName.indexOf (this.zipExtension));
	    
	}
	
	if (fName.endsWith (".doc"))
	{
	    
	    return "application/msword";
	    
	}
	
	if (fName.endsWith (".sdw"))
	{

	    return "application/x-swriter";

	}
	
	if (fName.endsWith (".rtf"))
	{
	    
	    return "text/rtf";

	}

	if (fName.endsWith (".html"))
	{
	    
	    return "text/html";

	}

	if (fName.endsWith (".txt"))
	{

	    return "text/plain";

	}	

	return "application/octet-stream";

    }

    public InputStream getInputStream ()
                                       throws IOException
    {

	return new GZIPInputStream (new BufferedInputStream (new FileInputStream (this.file)));

    }

    public OutputStream getOutputStream ()
                                         throws IOException
    {

	return new GZIPOutputStream (new BufferedOutputStream (new FileOutputStream (this.file)));

    }

    /**
     * Set the zip extension to use.
     *
     * @param ext The zip extension.
     */
    public void setZipExtension (String ext)
    {

	this.zipExtension = ext;

    }

    /**
     * Set the File to use for the data source.
     *
     * @param file The file.
     */
    public void setFile (File file)
    {

	this.file = file;

    }


    public String getName ()
    {

	String fName = this.file.getName ().toLowerCase ();

	// Strip off any gz file extension...
	if (fName.indexOf (this.zipExtension) != -1)
	{
	    
	    fName = fName.substring (0,
				     fName.indexOf (this.zipExtension));
	    
	}

	return fName;

    }

}
