/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.http.wechat;

import java.util.ArrayList;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.Must;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public enum WechatParams implements IEnumCombobox
{
    msgtype("\u6d88\u606f\u7c7b\u578b\uff0c\u6b64\u65f6\u56fa\u5b9a\u4e3atext", Must.yes),
    content("\u6587\u672c\u5185\u5bb9\uff0c\u6700\u957f\u4e0d\u8d85\u8fc72048\u4e2a\u5b57\u8282\uff0c\u5fc5\u987b\u662futf8\u7f16\u7801", Must.yes),
    mentioned_list("\u6587\u672c\u5185\u5bb9\uff0c\u6700\u957f\u4e0d\u8d85\u8fc72048\u4e2a\u5b57\u8282\uff0c\u5fc5\u987b\u662futf8\u7f16\u7801", Must.half, new String[]{"mentioned"}),
    mentioned_mobile_list("\u6587\u672c\u5185\u5bb9\uff0c\u6700\u957f\u4e0d\u8d85\u8fc72048\u4e2a\u5b57\u8282\uff0c\u5fc5\u987b\u662futf8\u7f16\u7801", Must.half, new String[]{"mentioned"});

    private final String desc;
    private final Must must;
    private final String[] mustGroups;

    private WechatParams(String desc, Must must, String[] mustGroups) {
        this.desc = desc;
        this.must = must;
        this.mustGroups = mustGroups;
    }

    private WechatParams(String desc, Must must) {
        this.desc = desc;
        this.must = must;
        this.mustGroups = null;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.name();
    }

    public WechatParams[] findByGroupOther(String mustGroup) {
        return WechatParams.findByGroup(mustGroup, this);
    }

    private static WechatParams[] findByGroup(String mustGroup, WechatParams notSelf) {
        if (StringUtil.isNull((Object)mustGroup)) {
            return new WechatParams[0];
        }
        ArrayList<WechatParams> retlist = new ArrayList<WechatParams>();
        for (WechatParams ele : WechatParams.values()) {
            if (!ArrayUtils.contains((Object[])ele.getGroups(), (Object)mustGroup) || notSelf == null || notSelf == ele) continue;
            retlist.add(ele);
        }
        return retlist.toArray(new WechatParams[retlist.size()]);
    }

    public static WechatParams[] findByGroup(String mustGroup) {
        return WechatParams.findByGroup(mustGroup, null);
    }

    public static WechatParams find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (WechatParams ele : WechatParams.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return null;
    }

    public Must getMust() {
        return this.must;
    }

    public String[] getMustGroups() {
        return this.mustGroups;
    }
}

