/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.http.wechat;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.Must;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 是与否枚举
 * 
 * @author andy.zhou
 * 
 */
public enum WechatParams implements IEnumCombobox {
	msgtype("消息类型，此时固定为text", Must.yes),

	content("文本内容，最长不超过2048个字节，必须是utf8编码", Must.yes),

	mentioned_list("文本内容，最长不超过2048个字节，必须是utf8编码", Must.half, new String[] { "mentioned" }),

	mentioned_mobile_list("文本内容，最长不超过2048个字节，必须是utf8编码", Must.half, new String[] { "mentioned" })
	;

	private final String desc;

	private final Must must;// null为与其它字段组合后必填一个

	private final String[] mustGroups;

	private WechatParams(String desc, Must must, String[] mustGroups) {
		this.desc = desc;
		this.must = must;
		this.mustGroups = mustGroups;
	}

	private WechatParams(String desc, Must must) {
		this.desc = desc;
		this.must = must;
		this.mustGroups = null;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public WechatParams[] findByGroupOther(String mustGroup) {
		return findByGroup(mustGroup, this);
	}

	private static WechatParams[] findByGroup(String mustGroup, WechatParams notSelf) {
		if (StringUtil.isNull(mustGroup)) {
			return new WechatParams[0];
		}
		List<WechatParams> retlist = new ArrayList<WechatParams>();
		for (WechatParams ele : WechatParams.values()) {
			if (ArrayUtils.contains(ele.getGroups(), mustGroup) && (notSelf != null && notSelf != ele)) {
				retlist.add(ele);
			}
		}
		return retlist.toArray(new WechatParams[retlist.size()]);
	}

	public static WechatParams[] findByGroup(String mustGroup) {
		return findByGroup(mustGroup, null);
	}

	public static WechatParams find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (WechatParams ele : WechatParams.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

	public Must getMust() {
		return must;
	}

	public String[] getMustGroups() {
		return mustGroups;
	}
}
