package net.wicp.tams.common.http.wechat;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.http.HttpClient;
import net.wicp.tams.common.http.HttpResult;
import net.wicp.tams.common.http.IHttpResultParser;

public class WechatMsg {
	private final String key;

	public WechatMsg(String key) {
		this.key = key;
	}

	public Result sendmsg(String mobilelist, String msg) {
		String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=%s", this.key);
		JSONObject sendmsg = new JSONObject();
		sendmsg.put(WechatParams.msgtype.name(), "text");
		JSONObject text = new JSONObject();
		sendmsg.put("text", text);
		text.put(WechatParams.content.name(), msg);
		text.put(WechatParams.mentioned_mobile_list.name(), mobilelist);
		HttpResult doPost = HttpClient.doPost(url, sendmsg);
		return doPost.getResult(new IHttpResultParser() {

			@Override
			public Result getObj(String value) {
				JSONObject jsonObject = JSONObject.parseObject(value);
				Long errcode = jsonObject.getLong("errcode");
				Result ret = errcode == 0 ? Result.getSuc() : Result.getError(jsonObject.getString("errmsg"));
				return ret;
			}
		});
	}
}
