/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.http;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.http.ReleaseConnectionThread;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpConnPool {
    private static Object lockobj = new Object();
    private static volatile HttpConnPool INSTANCE;
    private PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private RequestConfig requestConfig;
    private CloseableHttpClient defaultClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final HttpConnPool getInstance() {
        if (INSTANCE == null) {
            Object object = lockobj;
            synchronized (object) {
                if (INSTANCE == null) {
                    HttpConnPool tempobj = new HttpConnPool();
                    tempobj.cm = new PoolingHttpClientConnectionManager();
                    tempobj.cm.setMaxTotal(Integer.parseInt(StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.http.connpool.maxtotal"), "200"})));
                    tempobj.cm.setDefaultMaxPerRoute(Integer.parseInt(StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.http.connpool.maxperroute"), "20"})));
                    tempobj.requestConfig = RequestConfig.custom().setSocketTimeout(Integer.parseInt(StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.http.connpool.defaultconn.sockettimeout"), "5000"}))).setConnectTimeout(Integer.parseInt(StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.http.connpool.defaultconn.connecttimeout"), "5000"}))).setConnectionRequestTimeout(Integer.parseInt(StringUtil.hasNull((String[])new String[]{Conf.get((String)"common.http.connpool.defaultconn.requesttimeout"), "5000"}))).setStaleConnectionCheckEnabled(true).build();
                    tempobj.defaultClient = HttpClients.custom().setDefaultRequestConfig(tempobj.requestConfig).setConnectionManager((HttpClientConnectionManager)tempobj.cm).build();
                    new ReleaseConnectionThread((HttpClientConnectionManager)tempobj.cm).start();
                    INSTANCE = tempobj;
                }
            }
        }
        return INSTANCE;
    }

    public CloseableHttpClient newSSLClient(TrustStrategy trustStrategy) {
        SSLContext sslContext;
        if (trustStrategy == null) {
            trustStrategy = new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            };
        }
        try {
            sslContext = SSLContexts.custom().useTLS().loadTrustMaterial(null, trustStrategy).build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u521b\u5efa  SSLContext\u5f02\u5e38");
        }
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
        HttpClientBuilder build = HttpClients.custom().setDefaultRequestConfig(this.requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        return build.build();
    }

    public CloseableHttpClient newSSLClient() {
        return this.newSSLClient(null);
    }

    public void setMaxPerRoute(String host, int port, int maxnum) {
        HttpHost localhost = new HttpHost(host, port);
        this.cm.setMaxPerRoute(new HttpRoute(localhost), maxnum);
    }

    public CloseableHttpClient getClient() {
        if (this.defaultClient == null) {
            RequestConfig reqconfig = RequestConfig.custom().setSocketTimeout(5000).setConnectTimeout(Integer.parseInt(Conf.get((String)"common.http.connpool.defaultconn.connecttimeout"))).setConnectionRequestTimeout(Integer.parseInt(Conf.get((String)"common.http.connpool.defaultconn.requesttimeout"))).setStaleConnectionCheckEnabled(true).build();
            this.defaultClient = HttpClients.custom().setDefaultRequestConfig(reqconfig).setConnectionManager((HttpClientConnectionManager)this.cm).build();
        }
        return this.defaultClient;
    }

    public CloseableHttpClient newHttpClient() {
        return this.newHttpClient(null);
    }

    public CloseableHttpClient newHttpClient(CredentialsProvider credentialsProvider) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultRequestConfig(this.requestConfig).setConnectionManager((HttpClientConnectionManager)this.cm);
        if (credentialsProvider != null) {
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return httpClient;
    }
}

