/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.http.download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.CountDownLatch;

import lombok.extern.slf4j.Slf4j;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

/**
 * 
 * 负责文件下载的类
 */
@Slf4j
public class DownloadThread extends Thread {
	/**
	 * 
	 * 待下载的文件
	 */
	private String url = null;
	/**
	 * 
	 * 本地文件名
	 */
	private String fileName = null;
	/**
	 * 
	 * 偏移量
	 */
	private long offset = 0;
	/**
	 * 
	 * 分配给本线程的下载字节数
	 */
	private long length = 0;
	private CountDownLatch end;
	private CloseableHttpClient httpClient;
	private HttpContext context;

	/**
	 * 
	 * @param url
	 *            下载文件地址
	 * 
	 * @param fileName
	 *            另存文件名
	 * 
	 * @param offset
	 *            本线程下载偏移量
	 * 
	 * @param length
	 *            本线程下载长度
	 * 
	 * 
	 */

	public DownloadThread(String url, String fileName, long offset,
			long length, CountDownLatch end, CloseableHttpClient httpClient) {
		this.url = url;
		this.fileName = fileName;
		this.offset = offset;
		this.length = length;
		this.end = end;
		this.httpClient = httpClient;
		this.context = new BasicHttpContext();
		log.debug("偏移量=" + offset + ";字节数=" + length);
	}

	public void run() {
		try {
			HttpGet httpGet = new HttpGet(this.url);
			httpGet.addHeader("Range", "bytes=" + this.offset + "-"
					+ (this.offset + this.length - 1));
			CloseableHttpResponse response = httpClient.execute(httpGet,
					context);
			BufferedInputStream bis = new BufferedInputStream(response
					.getEntity().getContent());
			byte[] buff = new byte[1024];
			int bytesRead;
			File newFile = new File(fileName);
			RandomAccessFile raf = new RandomAccessFile(newFile, "rw");
			while ((bytesRead = bis.read(buff, 0, buff.length)) != -1) {
				raf.seek(this.offset);
				raf.write(buff, 0, bytesRead);
				this.offset = this.offset + bytesRead;
			}
			raf.close();
			bis.close();
		} catch (ClientProtocolException e) {
			log.error("DownloadThread exception msg:{}",
					ExceptionUtils.getStackTrace(e));
		} catch (IOException e) {
			log.error("DownloadThread exception msg:{}",
					ExceptionUtils.getStackTrace(e));
		} finally {
			end.countDown();
			log.info(end.getCount() + " is go on!");
		}
	}

}
