package net.wicp.tams.common.http;

import java.util.concurrent.TimeUnit;

import org.apache.http.conn.HttpClientConnectionManager;

public class ReleaseConnectionThread extends Thread {
	 
    private final HttpClientConnectionManager connMgr;
 
    private volatile boolean shutdown;
 
    public ReleaseConnectionThread(HttpClientConnectionManager connMgr) {
        this.connMgr = connMgr;
        this.shutdown = false;
    }
 
    @Override
    public void run() {
        try {
            while (!shutdown) {
                synchronized (this) {
                    // 等待2秒
                    wait(2000);
                    // 关闭失效连接
                    connMgr.closeExpiredConnections();
                    //关闭空闲超过5秒的连接
                    connMgr.closeIdleConnections(5000, TimeUnit.MILLISECONDS);
                }
            }
        } catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}
