/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.http;

import java.io.Serializable;

import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.protocol.HttpContext;

import net.wicp.tams.common.Result;

public class HttpResult implements Serializable {
	private static final long serialVersionUID = 1L;
	private HttpContext context;
	private byte[] body;
	private Header contentEncoding;
	private long contentLength;
	private Header contentType;
	private StatusLine statusLine;
	private String errMsg;
	private boolean isError;

	public String getErrMsg() {
		return errMsg;
	}

	public void setErrMsg(String errMsg) {
		this.isError = true;
		this.errMsg = errMsg;
	}

	public int getHttpStatus() {
		return this.statusLine == null ? 0 : this.statusLine.getStatusCode();
	}

	public StatusLine getStatusLine() {
		return statusLine;
	}

	public void setStatusLine(StatusLine statusLine) {
		this.statusLine = statusLine;
	}

	public long getContentLength() {
		return contentLength;
	}

	public void setContentLength(long contentLength) {
		this.contentLength = contentLength;
	}

	public Header getContentType() {
		return contentType;
	}

	public void setContentType(Header contentType) {
		this.contentType = contentType;
	}

	public HttpContext getContext() {
		return context;
	}

	public void setContext(HttpContext context) {
		this.context = context;
	}

	public byte[] getBody() {
		return body;
	}

	public String getBodyStr() {
		try {
			return new String(this.body, "UTF-8");
		} catch (Exception e) {
			return new String(this.body);
		}

	}

	public void setBody(byte[] body) {
		this.body = body;
	}

	public Header getContentEncoding() {
		return contentEncoding;
	}

	public void setContentEncoding(Header contentEncoding) {
		this.contentEncoding = contentEncoding;
	}

	public Result getResult() {
		if (isError) {
			return Result.getError(errMsg);
		} else {
			Result suc = Result.getSuc();
			suc.setRetObjs(this);
			return suc;
		}
	}

}
