/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.http;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.FutureTask;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HTTP;

import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectException;

@Slf4j
public abstract class HttpClient {

	public static final String ENCODE = "UTF-8";
	public static final String HEAD_TYPE = "application/json";
	public static final String CONTENT_TYPE = "text/json";
	public static final String headForFilename = "filename";// 上传文件时，把文件名做为head发送请求，这个head名

	public static HttpResult doGet(String url) {
		HttpRequestBase rq = new HttpGet(url);
		HttpThread ht = new HttpThread(rq);
		HttpResult result = ht.call();
		return result;
	}

	public static FutureTask<HttpResult> doGetAsyn(String url) {
		HttpRequestBase rq = new HttpGet(url);
		HttpThread ht = new HttpThread(rq);
		return ht.callAsyn();
	}

	public static HttpResult doPost(String url, JSONObject param, Header... headers) {
		HttpThread ht = doPostCommon(url, param.toJSONString(), headers);
		HttpResult result = ht.call();
		return result;
	}

	public static FutureTask<HttpResult> doPostAsyn(String url, JSONObject param, Header... headers) {
		HttpThread ht = doPostCommon(url, param.toJSONString(), headers);
		return ht.callAsyn();
	}

	public static HttpThread doPostCommon(String url, String param, Header... headers) {
		HttpPost rq = new HttpPost(url);
		rq.addHeader(HTTP.CONTENT_TYPE, HEAD_TYPE);
		if (ArrayUtils.isNotEmpty(headers)) {
			for (Header header : headers) {
				rq.addHeader(header);
			}
		}
		StringEntity se = new StringEntity(param, ENCODE);
		se.setContentType(CONTENT_TYPE);
		se.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE, HEAD_TYPE));
		rq.setEntity(se);
		HttpThread ht = new HttpThread(rq);
		return ht;
	}

	public static HttpResult doPostForm(String url, Map<String, Object> params, Header... headers) {
		HttpThread ht = doPostFormCommon(url, params, headers);
		HttpResult result = ht.call();
		return result;
	}

	public static HttpThread doPostFormCommon(String url, Map<String, Object> param, Header... headers) {
		HttpPost rq = new HttpPost(url);
		if (ArrayUtils.isNotEmpty(headers)) {
			for (Header header : headers) {
				rq.addHeader(header);
			}
		}
		MultipartEntityBuilder entityBuild = MultipartEntityBuilder.create()
				.setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(Charset.forName(ENCODE));// BROWSER_COMPATIBLE
																									// 设置浏览器兼容模式，解决文件名乱码问题
		for (String key : param.keySet()) {
			Object value = param.get(key);
			if ("java.io.File".equals(value.getClass().getName())) {
				FileBody pluginFile = new FileBody((File) value);
				entityBuild.addPart(key, pluginFile);
			} else if (value.getClass().isAssignableFrom(InputStream.class)) {// 是流，不是文件
				InputStreamBody inputStream = new InputStreamBody((InputStream) value, key);
				entityBuild.addPart(key, inputStream);
			} else {// TODO 如果是数组，如何处理
				StringBody context = new StringBody(String.valueOf(value),
						ContentType.create("text/plain", Consts.UTF_8));
				entityBuild.addPart(key, context);
			}
		}
		rq.setEntity(entityBuild.build());
		HttpThread ht = new HttpThread(rq);
		return ht;
	}

	public static HttpThread doPostXml(String url, String param, Header... headers) {
		String headType = net.wicp.tams.common.constant.ContentType.xbl.getValue();// "application/xml";
		HttpPost rq = new HttpPost(url);
		rq.addHeader(HTTP.CONTENT_TYPE, headType);
		if (ArrayUtils.isNotEmpty(headers)) {
			for (Header header : headers) {
				rq.addHeader(header);
			}
		}
		if (StringUtil.isNotNull(param)) {
			StringEntity se = new StringEntity(param, ENCODE);
			// se.setContentType(CONTENT_TYPE);
			se.setContentEncoding(new BasicHeader(HTTP.CONTENT_TYPE, headType));
			rq.setEntity(se);
		}
		HttpThread ht = new HttpThread(rq);
		return ht;
	}

	/***
	 * 上传jar包
	 * 
	 * @param url
	 * @param fileName
	 * @param in
	 * @param contentType
	 * @param headers
	 * @return
	 */
	public static HttpThread doPostFile(String url, String fileName, InputStream in,
			net.wicp.tams.common.constant.ContentType contentType, Header... headers) {
		if (StringUtil.isNull(fileName) || in == null) {
			return null;
		}
		String headType = net.wicp.tams.common.constant.ContentType.jar.getValue();// "application/xml";
		HttpPost rq = new HttpPost(url);
		rq.addHeader(HTTP.CONTENT_TYPE, headType);
		rq.addHeader(HttpClient.headForFilename, fileName);
		if (ArrayUtils.isNotEmpty(headers)) {
			for (Header header : headers) {
				rq.addHeader(header);
			}
		}
		InputStreamEntity inEntity = new InputStreamEntity(in, ContentType.create(headType));
		rq.setEntity(inEntity);
		HttpThread ht = new HttpThread(rq);
		return ht;
	}

	public static HttpThread doPostFile(String url, String fileName, InputStream in, Header... headers) {
		return doPostFile(url, fileName, in, net.wicp.tams.common.constant.ContentType.findByFileName(fileName),
				headers);
	}

	public static HttpThread doPostJar(String url, String jarFileName, InputStream in, Header... headers) {
		return doPostFile(url, jarFileName, in, net.wicp.tams.common.constant.ContentType.jar, headers);
	}

	/***
	 * 返回真正的URL
	 * 
	 * @param relaUrl
	 * @return
	 */
	public static String packurl(String relaUrl) {
		String context = Conf.get("common.apiext.context");
		if (StringUtil.isNull(context)) {
			context = String.format("%s://%s:%s", Conf.get("common.http.url.protocol"),
					Conf.get("common.http.url.host"), Conf.get("common.http.url.port"));
		}
		return IOUtil.mergeFolderAndFilePath(context, relaUrl);
	}

	/***
	 * 返回结果
	 * 
	 * @param relaUrl 相对地址
	 * @param params
	 * @return
	 * @throws ProjectException
	 */
	public static JSONObject doPostRela(String relaUrl, Object... params) throws ProjectException {
		JSONObject param = JSONUtil.packParams(params);
		return doPostRela(relaUrl, param);
	}

	public static JSONObject doPostRela(String relaUrl, JSONObject params) throws ProjectException {
		HttpResult ret = HttpClient.doPost(HttpClient.packurl(relaUrl), params);
		if (ret == null) {
			log.info("[url]:{} [params]:{}", relaUrl, params.toJSONString());
			throw new ProjectException(ExceptAll.project_timeout, "调用EB超时");
		}
		String retstr = ret.getBodyStr();
		JSONObject retjson = JSONObject.parseObject(retstr);
		return retjson;
	}

}
