/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.http.download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(DownloadThread.class);
    private String url = null;
    private String fileName = null;
    private long offset = 0L;
    private long length = 0L;
    private CountDownLatch end;
    private CloseableHttpClient httpClient;
    private HttpContext context;

    public DownloadThread(String url, String fileName, long offset, long length, CountDownLatch end, CloseableHttpClient httpClient) {
        this.url = url;
        this.fileName = fileName;
        this.offset = offset;
        this.length = length;
        this.end = end;
        this.httpClient = httpClient;
        this.context = new BasicHttpContext();
        log.debug("\u504f\u79fb\u91cf=" + offset + ";\u5b57\u8282\u6570=" + length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int bytesRead;
            HttpGet httpGet = new HttpGet(this.url);
            httpGet.addHeader("Range", "bytes=" + this.offset + "-" + (this.offset + this.length - 1L));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet, this.context);
            BufferedInputStream bis = new BufferedInputStream(response.getEntity().getContent());
            byte[] buff = new byte[1024];
            File newFile = new File(this.fileName);
            RandomAccessFile raf = new RandomAccessFile(newFile, "rw");
            while ((bytesRead = bis.read(buff, 0, buff.length)) != -1) {
                raf.seek(this.offset);
                raf.write(buff, 0, bytesRead);
                this.offset += (long)bytesRead;
            }
            raf.close();
            bis.close();
        }
        catch (ClientProtocolException e) {
            log.error("DownloadThread exception msg:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IOException e) {
            log.error("DownloadThread exception msg:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            this.end.countDown();
            log.info(this.end.getCount() + " is go on!");
        }
    }
}

