/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.http.download;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.http.download.DownloadThread;
import net.wicp.tams.common.thread.ThreadPool;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Download {
    private static final Logger log = LoggerFactory.getLogger(Download.class);
    private final String url;
    private final long fileSize;
    private final String dirPath;
    private final String fileName;
    private final String fileNameRemote;
    private final String filePath;
    private CloseableHttpClient httpClient;
    private long unitSize = 0x200000L;

    public Download(String url, long fileSize, String dirPath, String fileName) throws IOException {
        this.url = url;
        this.fileSize = fileSize < 0L ? this.getRemoteFileSize(url) : fileSize;
        this.fileNameRemote = StringUtil.getFileName((String)url);
        this.fileName = StringUtil.isNull((Object)fileName) ? this.fileNameRemote : fileName;
        this.dirPath = dirPath;
        this.filePath = IOUtil.mergeFolderAndFilePath((String)dirPath, (String[])new String[]{this.fileName});
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    public Download(String url, String dirPath) throws IOException {
        this(url, -1L, dirPath, null);
    }

    public String download() throws IOException {
        IOUtil.createFile((String)this.filePath, (long)this.fileSize);
        Long threadCount = this.fileSize / this.unitSize + (long)(this.fileSize % this.unitSize != 0L ? 1 : 0);
        long offset = 0L;
        CountDownLatch end = new CountDownLatch(threadCount.intValue());
        if (this.fileSize <= this.unitSize) {
            DownloadThread downloadThread = new DownloadThread(this.url, this.filePath, offset, this.fileSize, end, this.httpClient);
            ThreadPool.getDefaultPool().submit(downloadThread);
        } else {
            int i = 1;
            while ((long)i < threadCount) {
                DownloadThread downloadThread = new DownloadThread(this.url, this.filePath, offset, this.unitSize, end, this.httpClient);
                ThreadPool.getDefaultPool().submit(downloadThread);
                offset += this.unitSize;
                ++i;
            }
            if (this.fileSize % this.unitSize != 0L) {
                DownloadThread downloadThread = new DownloadThread(this.url, this.filePath, offset, this.fileSize - this.unitSize * (threadCount - 1L), end, this.httpClient);
                ThreadPool.getDefaultPool().submit(downloadThread);
            }
        }
        try {
            end.await();
        }
        catch (InterruptedException e) {
            log.error("DownLoadManager exception msg:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            e.printStackTrace();
        }
        log.info("\u4e0b\u8f7d\u5b8c\u6210\uff01{} ", (Object)this.filePath);
        return this.filePath;
    }

    private long getRemoteFileSize(String remoteFileUrl) throws IOException {
        String sHeader;
        long fileSize = 0L;
        HttpURLConnection httpConnection = (HttpURLConnection)new URL(remoteFileUrl).openConnection();
        httpConnection.setRequestMethod("HEAD");
        int responseCode = httpConnection.getResponseCode();
        if (responseCode >= 400) {
            log.debug("Web\u670d\u52a1\u5668\u54cd\u5e94\u9519\u8bef!");
            return 0L;
        }
        int i = 1;
        while (true) {
            if ((sHeader = httpConnection.getHeaderFieldKey(i)) != null && sHeader.equals("Content-Length")) break;
            ++i;
        }
        System.out.println("\u6587\u4ef6\u5927\u5c0fContentLength:" + httpConnection.getContentLength());
        fileSize = Long.parseLong(httpConnection.getHeaderField(sHeader));
        return fileSize;
    }
}

