/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.http;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.FutureTask;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.http.HttpResult;
import net.wicp.tams.common.http.HttpThread;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    public static final String ENCODE = "UTF-8";
    public static final String HEAD_TYPE = "application/json";
    public static final String CONTENT_TYPE = "text/json";

    public static HttpResult doGet(String url) {
        HttpGet rq = new HttpGet(url);
        HttpThread ht = new HttpThread((HttpRequestBase)rq);
        HttpResult result = ht.call();
        return result;
    }

    public static FutureTask<HttpResult> doGetAsyn(String url) {
        HttpGet rq = new HttpGet(url);
        HttpThread ht = new HttpThread((HttpRequestBase)rq);
        return ht.callAsyn();
    }

    public static HttpResult doPost(String url, JSONObject param, Header ... headers) {
        HttpThread ht = HttpClient.doPostCommon(url, param.toJSONString(), headers);
        HttpResult result = ht.call();
        return result;
    }

    public static FutureTask<HttpResult> doPostAsyn(String url, JSONObject param, Header ... headers) {
        HttpThread ht = HttpClient.doPostCommon(url, param.toJSONString(), headers);
        return ht.callAsyn();
    }

    public static HttpThread doPostCommon(String url, String param, Header ... headers) {
        HttpPost rq = new HttpPost(url);
        rq.addHeader("Content-Type", HEAD_TYPE);
        if (ArrayUtils.isNotEmpty((Object[])headers)) {
            for (Header header : headers) {
                rq.addHeader(header);
            }
        }
        StringEntity se = new StringEntity(param, ENCODE);
        se.setContentType(CONTENT_TYPE);
        se.setContentEncoding((Header)new BasicHeader("Content-Type", HEAD_TYPE));
        rq.setEntity((HttpEntity)se);
        HttpThread ht = new HttpThread((HttpRequestBase)rq);
        return ht;
    }

    public static HttpResult doPostForm(String url, Map<String, Object> params, Header ... headers) {
        HttpThread ht = HttpClient.doPostFormCommon(url, params, headers);
        HttpResult result = ht.call();
        return result;
    }

    public static HttpThread doPostFormCommon(String url, Map<String, Object> param, Header ... headers) {
        HttpPost rq = new HttpPost(url);
        if (ArrayUtils.isNotEmpty((Object[])headers)) {
            for (Header header : headers) {
                rq.addHeader(header);
            }
        }
        MultipartEntityBuilder entityBuild = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).setCharset(Charset.forName(ENCODE));
        for (String key : param.keySet()) {
            Object value = param.get(key);
            if ("java.io.File".equals(value.getClass().getName())) {
                FileBody pluginFile = new FileBody((File)value);
                entityBuild.addPart(key, (ContentBody)pluginFile);
                continue;
            }
            StringBody context = new StringBody(String.valueOf(value), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
            entityBuild.addPart(key, (ContentBody)context);
        }
        rq.setEntity(entityBuild.build());
        HttpThread ht = new HttpThread((HttpRequestBase)rq);
        return ht;
    }

    public static HttpThread doPostXml(String url, String param, Header ... headers) {
        String headType = "application/xml";
        HttpPost rq = new HttpPost(url);
        rq.addHeader("Content-Type", headType);
        if (ArrayUtils.isNotEmpty((Object[])headers)) {
            for (Header header : headers) {
                rq.addHeader(header);
            }
        }
        if (StringUtil.isNotNull((Object)param)) {
            StringEntity se = new StringEntity(param, ENCODE);
            se.setContentEncoding((Header)new BasicHeader("Content-Type", headType));
            rq.setEntity((HttpEntity)se);
        }
        HttpThread ht = new HttpThread((HttpRequestBase)rq);
        return ht;
    }

    public static String packurl(String relaUrl) {
        String context = Conf.get((String)"common.apiext.context");
        if (StringUtil.isNull((Object)context)) {
            context = String.format("%s://%s:%s", Conf.get((String)"common.http.url.protocol"), Conf.get((String)"common.http.url.host"), Conf.get((String)"common.http.url.port"));
        }
        return IOUtil.mergeFolderAndFilePath((String)context, (String[])new String[]{relaUrl});
    }

    public static JSONObject doPostRela(String relaUrl, Object ... params) throws ProjectException {
        JSONObject param = JSONUtil.packParams((Object[])params);
        return HttpClient.doPostRela(relaUrl, param);
    }

    public static JSONObject doPostRela(String relaUrl, JSONObject params) throws ProjectException {
        HttpResult ret = HttpClient.doPost(HttpClient.packurl(relaUrl), params, new Header[0]);
        if (ret == null) {
            log.info("[url]:{} [params]:{}", (Object)relaUrl, (Object)params.toJSONString());
            throw new ProjectException((IExcept)ExceptAll.project_timeout, "\u8c03\u7528EB\u8d85\u65f6");
        }
        String retstr = ret.getBodyStr();
        JSONObject retjson = JSONObject.parseObject((String)retstr);
        return retjson;
    }
}

