package net.wicp.tams.common.http.plugin;

import java.io.Serializable;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.Middleware;
import net.wicp.tams.common.constant.ods.AddColName;

/***
 * 需要把界面的dump配置转成Dump对象
 * 
 * @author andy.zhou
 *
 */
public class DumperHttp implements IBusiSender<DumpEvent> {
	static {
		// 防止自定义classload的时错过默认的加载配置,再次加载配置文件
		Conf.overConf("/common-http.properties", ListenerHttp.class, false);
	}

	@Override
	public void init(Dump dump) {
//		Validate.notEmpty(dump.getBusiPluginConfig(), "需要扩展属性，它是一个json且包含有 httpRela值。");
//		Validate.notBlank(dump.getBusiPluginConfig().getString("httpRela"), "需要扩展属性，它是一个json且包含有 httpRela值。");
//		this.httpRela = dump.getBusiPluginConfig().getString("httpRela");
		dump.getRule().checkRule(Middleware.http);
	}

	@Override
	public void doSend(DumpEvent dumpEvent, Map<AddColName, Serializable> addValues, String newDb, String newTb) {
		JSONObject data = DumpEvent.convertJson(dumpEvent);
		HttpPluginAssit.sendMsg(dumpEvent.getDump().getRule().getRuleItem(RuleItem.httpRela), data);
	}

}
