package net.wicp.tams.common.http.plugin;

import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.LoggerUtil;
import net.wicp.tams.common.apiext.TimeAssist;
import net.wicp.tams.common.constant.JvmStatus;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.http.HttpClient;
import net.wicp.tams.common.http.HttpResult;

@Slf4j
public abstract class HttpPluginAssit {
	/****
	 * binlog data结构：
	 * {'optType':'update',items:[{'before':{'field1':'value1','field2':'value2'},'after':{'field1':'value1','field2':'value22'}]}
	 * 
	 * dump data结构：
	 * {'optType':'select',items:['after':{'field1':'value1','field2':'value22'}]}
	 * 
	 * @param url
	 * @param data
	 */
	public static void sendMsg(String url, JSONObject data) {
		while (true) {
			try {
				HttpResult ret = HttpClient.doPostCommon(url, data.toJSONString()).call();
				log.info("return:{}", ret.getBodyStr());
				if (ret.getResult().isSuc()) {
					// break;
					throw new ProjectException(ExceptAll.Project_default, ret.getBodyStr());// 失败重试
				} else {
					throw new ProjectException(ExceptAll.Project_default, ret.getBodyStr());// 失败重试
				}
			} catch (Throwable e) {
				Integer reNum = Conf.getInt("common.http.retry");
				if (reNum < 0) {// 无限次重试
					log.error("send http error,need try:" + reNum, e);
					continue;
				} else if (reNum == 0) {// 不重试
					log.error("send http error,need try:" + reNum, e);
					break;
				} else {
					boolean reDoWait = TimeAssist.reDoWait("duckula-plugin-http", reNum);
					if (reDoWait) {// 达到最大值就出
						log.error("重试" + reNum + "次都不能拿到链接，退出");
						LoggerUtil.exit(JvmStatus.s15);
					} else {
						log.error("不能发送数据，重试", e);
						continue;
					}
				}
			}
		}
	}
}
