/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.http;

import java.io.Serializable;
import net.wicp.tams.common.Result;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.protocol.HttpContext;

public class HttpResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HttpContext context;
    private byte[] body;
    private Header contentEncoding;
    private long contentLength;
    private Header contentType;
    private StatusLine statusLine;
    private String errMsg;
    private boolean isError;

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.isError = true;
        this.errMsg = errMsg;
    }

    public int getHttpStatus() {
        return this.statusLine == null ? 0 : this.statusLine.getStatusCode();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public void setStatusLine(StatusLine statusLine) {
        this.statusLine = statusLine;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public Header getContentType() {
        return this.contentType;
    }

    public void setContentType(Header contentType) {
        this.contentType = contentType;
    }

    public HttpContext getContext() {
        return this.context;
    }

    public void setContext(HttpContext context) {
        this.context = context;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyStr() {
        try {
            return new String(this.body, "UTF-8");
        }
        catch (Exception e) {
            return new String(this.body);
        }
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(Header contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public Result getResult() {
        if (this.isError) {
            return Result.getError((String)this.errMsg);
        }
        Result suc = Result.getSuc();
        suc.setRetObjs((Object[])new HttpResult[]{this});
        return suc;
    }
}

