package net.wicp.tams.common.http;

import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.thread.ThreadPool;

public class HttpThread implements Callable<HttpResult> {

	private final CloseableHttpClient httpClient;
	private final HttpContext context;
	private final HttpRequestBase httpReq;

	public HttpThread(CloseableHttpClient httpClient, HttpRequestBase httpReq, HttpContext context) {
		this.httpClient = httpClient;
		this.context = context;
		this.httpReq = httpReq;
	}

	public HttpThread(CloseableHttpClient httpClient, HttpRequestBase httpReq) {
		this.httpClient = httpClient;
		this.context = HttpClientContext.create();
		this.httpReq = httpReq;
	}

	public HttpThread(HttpRequestBase httpReq, String username, String pwd) {
		// this.httpClient = HttpConnPool.getInstance().getClient();
		this.context = HttpClientContext.create();
		this.httpReq = httpReq;
		if (StringUtil.isNotNull(username) && StringUtil.isNotNull(pwd)) {
			URI uri = httpReq.getURI();
			HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
			CredentialsProvider credsProvider = new BasicCredentialsProvider();
			credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()),
					new UsernamePasswordCredentials(username, pwd));
			AuthCache authCache = new BasicAuthCache();
			BasicScheme basicAuth = new BasicScheme();
			authCache.put(host, basicAuth);
			this.httpClient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();
			((HttpClientContext) this.context).setAuthCache(authCache);
		} else {
			this.httpClient = HttpClients.custom().build();
		}
	}

	public HttpThread(HttpRequestBase httpReq) {
		this(httpReq, Conf.get("common.http.username"), Conf.get("common.http.pwd"));
	}

	@Override
	public HttpResult call() {
		HttpResult ret = new HttpResult();
		try {
			CloseableHttpResponse response = httpClient.execute(httpReq, context);
			try {
				HttpEntity entity = response.getEntity();
				ret.setContext(context);
				ret.setBody(IOUtils.toByteArray(entity.getContent()));
				ret.setContentLength(entity.getContentLength());
				ret.setContentType(entity.getContentType());
				ret.setContentEncoding(entity.getContentEncoding());
				ret.setStatusLine(response.getStatusLine());
			} finally {
				response.close();
			}
		} catch (Exception ex) {
			ret.setErrMsg(ex.getMessage());
		}
		return ret;
	}

	/***
	 * 异步调用，如果不需要返回值可忽略，如果需要返回值用 task.get(); 会阻塞线程
	 */
	public FutureTask<HttpResult> callAsyn() {
		FutureTask<HttpResult> task = new FutureTask<HttpResult>(this);
		ThreadPool.getDefaultPool().submit(task);
		return task;
	}

	public HttpResult callBlock() {
		FutureTask<HttpResult> task = callAsyn();
		HttpResult ret = null;
		try {
			ret = task.get();
		} catch (InterruptedException e) {
			e.printStackTrace();
		} catch (ExecutionException e) {
			e.printStackTrace();
		}
		return ret;
	}

}
